/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.support.events.logout.CasRequestSingleLogoutEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.SingleSignOnBuildingStrategy;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultSingleSignOnBuildingStrategy
implements SingleSignOnBuildingStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleSignOnBuildingStrategy.class);
    protected final TicketRegistrySupport ticketRegistrySupport;
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final ConfigurableApplicationContext applicationContext;

    public Ticket buildTicketGrantingTicket(AuthenticationResult authenticationResult, Authentication authentication, String ticketGrantingTicket) {
        try {
            return this.shouldIssueTicketGrantingTicket(authentication, ticketGrantingTicket) ? this.createTicketGrantingTicket(authenticationResult, ticketGrantingTicket) : this.updateTicketGrantingTicket(authentication, ticketGrantingTicket);
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            if (e instanceof PrincipalException) {
                PrincipalException pe = (PrincipalException)e;
                throw pe;
            }
            throw new InvalidTicketException(ticketGrantingTicket);
        }
    }

    protected Ticket createTicketGrantingTicket(AuthenticationResult authenticationResult, String ticketGrantingTicket) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)ticketGrantingTicket)) {
            this.removeTicketGrantingTicket(ticketGrantingTicket);
        }
        LOGGER.trace("Attempting to issue a new ticket-granting ticket...");
        return this.centralAuthenticationService.createTicketGrantingTicket(authenticationResult);
    }

    protected void removeTicketGrantingTicket(String ticketGrantingTicketId) throws Throwable {
        TicketGrantingTicket ticket = (TicketGrantingTicket)this.ticketRegistrySupport.getTicket(ticketGrantingTicketId);
        if (ticket == null) {
            LOGGER.trace("Existing ticket-granting ticket [{}] not found or expired", (Object)ticketGrantingTicketId);
            return;
        }
        LOGGER.trace("Removing existing ticket-granting ticket [{}]", (Object)ticketGrantingTicketId);
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        this.applicationContext.publishEvent((ApplicationEvent)new CasRequestSingleLogoutEvent((Object)this, ticket, clientInfo));
        this.ticketRegistrySupport.getTicketRegistry().deleteTicket(ticketGrantingTicketId);
        this.applicationContext.publishEvent((ApplicationEvent)new CasTicketGrantingTicketDestroyedEvent((Object)this, ticket, clientInfo));
    }

    protected Ticket updateTicketGrantingTicket(Authentication authentication, String ticketGrantingTicketId) throws Exception {
        LOGGER.debug("Updating existing ticket-granting ticket [{}]...", (Object)ticketGrantingTicketId);
        TicketGrantingTicket grantingTicket = (TicketGrantingTicket)this.ticketRegistrySupport.getTicketRegistry().getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        DefaultSingleSignOnBuildingStrategy.updateAuthentication(grantingTicket, authentication);
        return this.ticketRegistrySupport.getTicketRegistry().updateTicket((Ticket)grantingTicket);
    }

    protected static void updateAuthentication(TicketGrantingTicket ticketGrantingTicket, Authentication authentication) {
        ticketGrantingTicket.getAuthentication().updateAttributes(authentication);
    }

    protected boolean shouldIssueTicketGrantingTicket(Authentication authentication, String ticketGrantingTicket) throws Throwable {
        LOGGER.trace("Located ticket-granting ticket in the context. Retrieving associated authentication");
        Authentication authenticationFromTgt = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicket);
        if (authenticationFromTgt == null) {
            LOGGER.debug("Authentication session associated with [{}] is no longer valid", (Object)ticketGrantingTicket);
            if (StringUtils.isNotBlank((CharSequence)ticketGrantingTicket)) {
                this.removeTicketGrantingTicket(ticketGrantingTicket);
            }
            return true;
        }
        return this.isAuthenticationAttemptTheSame(authentication, authenticationFromTgt);
    }

    protected boolean isAuthenticationAttemptTheSame(Authentication currentAuthentication, Authentication previousAuthentication) {
        if (currentAuthentication.isEqualTo(previousAuthentication)) {
            LOGGER.debug("Resulting authentication matches the authentication from context");
            return false;
        }
        LOGGER.debug("Resulting authentication is different from the context");
        return true;
    }

    @Generated
    public DefaultSingleSignOnBuildingStrategy(TicketRegistrySupport ticketRegistrySupport, CentralAuthenticationService centralAuthenticationService, ConfigurableApplicationContext applicationContext) {
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.centralAuthenticationService = centralAuthenticationService;
        this.applicationContext = applicationContext;
    }
}

