/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.ExtensionInputs;
import com.yubico.webauthn.data.Extensions;
import com.yubico.webauthn.extension.appid.AppId;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class RegistrationExtensionInputs
implements ExtensionInputs {
    private final AppId appidExclude;
    private final Boolean credProps;
    private final Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob;
    private final Boolean uvm;

    @JsonCreator
    private RegistrationExtensionInputs(@JsonProperty(value="appidExclude") AppId appidExclude, @JsonProperty(value="credProps") Boolean credProps, @JsonProperty(value="largeBlob") Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob, @JsonProperty(value="uvm") Boolean uvm) {
        this.appidExclude = appidExclude;
        this.credProps = credProps;
        this.largeBlob = largeBlob;
        this.uvm = uvm;
    }

    public RegistrationExtensionInputs merge(RegistrationExtensionInputs other) {
        return new RegistrationExtensionInputs(this.appidExclude != null ? this.appidExclude : other.appidExclude, this.credProps != null ? this.credProps : other.credProps, this.largeBlob != null ? this.largeBlob : other.largeBlob, this.uvm != null ? this.uvm : other.uvm);
    }

    public Optional<AppId> getAppidExclude() {
        return Optional.ofNullable(this.appidExclude);
    }

    public boolean getCredProps() {
        return this.credProps != null && this.credProps != false;
    }

    @JsonProperty(value="credProps")
    private Boolean getCredPropsJson() {
        return this.getCredProps() ? Boolean.valueOf(true) : null;
    }

    public Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> getLargeBlob() {
        return Optional.ofNullable(this.largeBlob);
    }

    public boolean getUvm() {
        return this.uvm != null && this.uvm != false;
    }

    @JsonProperty(value="uvm")
    private Boolean getUvmJson() {
        return this.getUvm() ? Boolean.valueOf(true) : null;
    }

    @Override
    public Set<String> getExtensionIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.appidExclude != null) {
            ids.add("appidExclude");
        }
        if (this.getCredProps()) {
            ids.add("credProps");
        }
        if (this.largeBlob != null) {
            ids.add("largeBlob");
        }
        if (this.getUvm()) {
            ids.add("uvm");
        }
        return Collections.unmodifiableSet(ids);
    }

    @Generated
    public static RegistrationExtensionInputsBuilder builder() {
        return new RegistrationExtensionInputsBuilder();
    }

    @Generated
    public RegistrationExtensionInputsBuilder toBuilder() {
        return new RegistrationExtensionInputsBuilder().appidExclude(this.appidExclude).credProps(this.credProps).largeBlob(this.largeBlob).uvm(this.uvm);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistrationExtensionInputs)) {
            return false;
        }
        RegistrationExtensionInputs other = (RegistrationExtensionInputs)o;
        if (this.getCredProps() != other.getCredProps()) {
            return false;
        }
        if (this.getUvm() != other.getUvm()) {
            return false;
        }
        Optional<AppId> this$appidExclude = this.getAppidExclude();
        Optional<AppId> other$appidExclude = other.getAppidExclude();
        if (this$appidExclude == null ? other$appidExclude != null : !((Object)this$appidExclude).equals(other$appidExclude)) {
            return false;
        }
        Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> this$largeBlob = this.getLargeBlob();
        Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> other$largeBlob = other.getLargeBlob();
        return !(this$largeBlob == null ? other$largeBlob != null : !((Object)this$largeBlob).equals(other$largeBlob));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getCredProps() ? 79 : 97);
        result = result * 59 + (this.getUvm() ? 79 : 97);
        Optional<AppId> $appidExclude = this.getAppidExclude();
        result = result * 59 + ($appidExclude == null ? 43 : ((Object)$appidExclude).hashCode());
        Optional<Extensions.LargeBlob.LargeBlobRegistrationInput> $largeBlob = this.getLargeBlob();
        result = result * 59 + ($largeBlob == null ? 43 : ((Object)$largeBlob).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegistrationExtensionInputs(appidExclude=" + this.getAppidExclude() + ", credProps=" + this.getCredProps() + ", largeBlob=" + this.getLargeBlob() + ", uvm=" + this.getUvm() + ")";
    }

    public static class RegistrationExtensionInputsBuilder {
        @Generated
        private AppId appidExclude;
        @Generated
        private Boolean credProps;
        @Generated
        private Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob;
        @Generated
        private Boolean uvm;

        public RegistrationExtensionInputsBuilder appidExclude(Optional<AppId> appidExclude) {
            this.appidExclude = appidExclude.orElse(null);
            return this;
        }

        public RegistrationExtensionInputsBuilder appidExclude(AppId appidExclude) {
            this.appidExclude = appidExclude;
            return this;
        }

        public RegistrationExtensionInputsBuilder credProps() {
            this.credProps = true;
            return this;
        }

        public RegistrationExtensionInputsBuilder credProps(Boolean credProps) {
            this.credProps = credProps;
            return this;
        }

        public RegistrationExtensionInputsBuilder largeBlob(Extensions.LargeBlob.LargeBlobRegistrationInput.LargeBlobSupport support) {
            this.largeBlob = new Extensions.LargeBlob.LargeBlobRegistrationInput(support);
            return this;
        }

        public RegistrationExtensionInputsBuilder largeBlob(Extensions.LargeBlob.LargeBlobRegistrationInput largeBlob) {
            this.largeBlob = largeBlob;
            return this;
        }

        public RegistrationExtensionInputsBuilder uvm() {
            this.uvm = true;
            return this;
        }

        private RegistrationExtensionInputsBuilder uvm(Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        @Generated
        RegistrationExtensionInputsBuilder() {
        }

        @Generated
        public RegistrationExtensionInputs build() {
            return new RegistrationExtensionInputs(this.appidExclude, this.credProps, this.largeBlob, this.uvm);
        }

        @Generated
        public String toString() {
            return "RegistrationExtensionInputs.RegistrationExtensionInputsBuilder(appidExclude=" + this.appidExclude + ", credProps=" + this.credProps + ", largeBlob=" + this.largeBlob + ", uvm=" + this.uvm + ")";
        }
    }
}

