/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.CoreSamlMetadataProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.CachedMetadataResolverResult;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataExpirationPolicy;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.criterion.SatisfyAnyCriterion;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Monitorable
public class SamlRegisteredServiceDefaultCachingMetadataResolver
implements SamlRegisteredServiceCachingMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceDefaultCachingMetadataResolver.class);
    private final LoadingCache<SamlRegisteredServiceCacheKey, CachedMetadataResolverResult> cache;
    private final OpenSamlConfigBean openSamlConfigBean;
    private final CasConfigurationProperties casProperties;

    public SamlRegisteredServiceDefaultCachingMetadataResolver(CasConfigurationProperties casProperties, CacheLoader<SamlRegisteredServiceCacheKey, CachedMetadataResolverResult> loader, OpenSamlConfigBean openSamlConfigBean) {
        this.openSamlConfigBean = openSamlConfigBean;
        this.casProperties = casProperties;
        CoreSamlMetadataProperties core = casProperties.getAuthn().getSamlIdp().getMetadata().getCore();
        Duration metadataCacheExpiration = Beans.newDuration((String)core.getCacheExpiration());
        this.cache = Caffeine.newBuilder().maximumSize(core.getCacheMaximumSize()).recordStats().expireAfter((Expiry)new SamlRegisteredServiceMetadataExpirationPolicy(metadataCacheExpiration)).build(loader);
    }

    private static long countResolvableEntityDescriptors(MetadataResolutionResult result) {
        return ((Integer)FunctionUtils.doUnchecked(() -> {
            EvaluableEntityRoleEntityDescriptorCriterion criteria = new EvaluableEntityRoleEntityDescriptorCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            return Iterables.size((Iterable)result.getResult().getMetadataResolver().resolve((Object)new CriteriaSet(new Criterion[]{criteria})));
        })).intValue();
    }

    public CachedMetadataResolverResult resolve(SamlRegisteredService service, CriteriaSet criteriaSet) throws Exception {
        String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
        LOGGER.debug("Resolving metadata for [{}] at [{}]", (Object)service.getName(), (Object)metadataLocation);
        SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        return (CachedMetadataResolverResult)FunctionUtils.doAndRetry(retryContext -> {
            LOGGER.debug("Locating cached metadata resolver using key [{}] for service [{}]. Attempt [{}]", new Object[]{cacheKey.getId(), service.getName(), retryContext.getRetryCount()});
            MetadataResolverCacheQueryResult queryResult = this.locateAndCacheMetadataResolver(service, criteriaSet, cacheKey);
            MetadataResolutionResult result = this.isMetadataResolverAcceptable(queryResult, criteriaSet);
            if (!result.isValid()) {
                long count = SamlRegisteredServiceDefaultCachingMetadataResolver.countResolvableEntityDescriptors(result);
                if (count == 1L) {
                    this.invalidate(service, criteriaSet);
                }
                LOGGER.warn("SAML metadata resolver [{}] obtained from the cache is unable to produce/resolve valid metadata from [{}]. Metadata resolver cache entry with key [{}] has been invalidated. Attempt: [#{}]", new Object[]{result.getResult().getMetadataResolver().getId(), metadataLocation, cacheKey.getId(), retryContext.getRetryCount()});
                throw new SamlException("Unable to locate a valid SAML metadata resolver for " + metadataLocation + " to locate " + String.valueOf(criteriaSet));
            }
            return queryResult.getResult();
        }, (int)this.casProperties.getAuthn().getSamlIdp().getMetadata().getCore().getMaximumRetryAttempts());
    }

    public void invalidate() {
        LOGGER.trace("Invalidating cache, removing all metadata resolvers");
        this.cache.invalidateAll();
    }

    public void invalidate(SamlRegisteredService service, CriteriaSet criteriaSet) {
        LOGGER.trace("Invalidating cache for [{}].", (Object)service.getName());
        SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        this.cache.invalidate((Object)cacheKey);
    }

    public Optional<CachedMetadataResolverResult> getIfPresent(SamlRegisteredService service, CriteriaSet criteriaSet) {
        LOGGER.trace("Invalidating cache for [{}].", (Object)service.getName());
        SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        return Optional.ofNullable((CachedMetadataResolverResult)this.cache.getIfPresent((Object)cacheKey));
    }

    protected MetadataResolutionResult isMetadataResolverAcceptable(MetadataResolverCacheQueryResult queryResult, CriteriaSet criteriaSet) {
        if (criteriaSet.contains(SatisfyAnyCriterion.class)) {
            return ((MetadataResolutionResult.MetadataResolutionResultBuilder)((MetadataResolutionResult.MetadataResolutionResultBuilder)MetadataResolutionResult.builder().entityDescriptor(Optional.empty())).valid(true)).build();
        }
        EntityDescriptor entityDescriptor = queryResult.getEntityDescriptor().orElseGet(Unchecked.supplier(() -> (EntityDescriptor)queryResult.getResult().getMetadataResolver().resolveSingle((Object)criteriaSet)));
        return ((MetadataResolutionResult.MetadataResolutionResultBuilder)((MetadataResolutionResult.MetadataResolutionResultBuilder)((MetadataResolutionResult.MetadataResolutionResultBuilder)MetadataResolutionResult.builder().valid(entityDescriptor != null && entityDescriptor.isValid())).entityDescriptor(Optional.ofNullable(entityDescriptor))).result(queryResult.getResult())).build();
    }

    protected MetadataResolverCacheQueryResult locateAndCacheMetadataResolver(SamlRegisteredService service, CriteriaSet criteriaSet, SamlRegisteredServiceCacheKey cacheKey) {
        Optional<MetadataResolverCacheQueryResult> cachedEntry = this.cache.asMap().values().stream().filter(Objects::nonNull).map(Unchecked.function(res -> {
            EntityDescriptor entity = (EntityDescriptor)res.getMetadataResolver().resolveSingle((Object)criteriaSet);
            return Optional.ofNullable(entity).map(e -> ((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)MetadataResolverCacheQueryResult.builder().result((CachedMetadataResolverResult)res)).entityDescriptor(Optional.of(e))).build());
        })).filter(Optional::isPresent).flatMap(Optional::stream).filter(MetadataResolverCacheQueryResult::isValid).findFirst();
        if (cachedEntry.isPresent() && cachedEntry.get().isValid()) {
            return cachedEntry.get();
        }
        LOGGER.debug("Loading metadata resolver from the cache using [{}]", (Object)cacheKey.getCacheKey());
        CachedMetadataResolverResult cacheResult = Objects.requireNonNull((CachedMetadataResolverResult)this.cache.get((Object)cacheKey));
        LOGGER.debug("Loaded and cached SAML metadata [{}] from [{}]", (Object)cacheResult.getMetadataResolver().getId(), (Object)service.getMetadataLocation());
        Assert.isTrue((boolean)cacheResult.isResolved(), (String)("Metadata resolver cannot be found from the cache for " + service.getName()));
        return ((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)MetadataResolverCacheQueryResult.builder().entityDescriptor(Optional.empty())).result(cacheResult)).build();
    }

    Optional<MetadataResolver> resolveIfPresent(SamlRegisteredService service, CriteriaSet criteriaSet) {
        SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        return Optional.ofNullable((CachedMetadataResolverResult)this.cache.getIfPresent((Object)cacheKey)).map(CachedMetadataResolverResult::getMetadataResolver);
    }

    CacheStats getCacheStatistics() {
        return this.cache.stats();
    }

    @Generated
    public OpenSamlConfigBean getOpenSamlConfigBean() {
        return this.openSamlConfigBean;
    }

    private static final class MetadataResolutionResult {
        private final boolean valid;
        private final Optional<EntityDescriptor> entityDescriptor;
        private final CachedMetadataResolverResult result;

        @Generated
        protected MetadataResolutionResult(MetadataResolutionResultBuilder<?, ?> b) {
            this.valid = b.valid;
            this.entityDescriptor = b.entityDescriptor;
            this.result = b.result;
        }

        @Generated
        public static MetadataResolutionResultBuilder<?, ?> builder() {
            return new MetadataResolutionResultBuilderImpl();
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public Optional<EntityDescriptor> getEntityDescriptor() {
            return this.entityDescriptor;
        }

        @Generated
        public CachedMetadataResolverResult getResult() {
            return this.result;
        }

        @Generated
        public static abstract class MetadataResolutionResultBuilder<C extends MetadataResolutionResult, B extends MetadataResolutionResultBuilder<C, B>> {
            @Generated
            private boolean valid;
            @Generated
            private Optional<EntityDescriptor> entityDescriptor;
            @Generated
            private CachedMetadataResolverResult result;

            @Generated
            public B valid(boolean valid) {
                this.valid = valid;
                return this.self();
            }

            @Generated
            public B entityDescriptor(Optional<EntityDescriptor> entityDescriptor) {
                this.entityDescriptor = entityDescriptor;
                return this.self();
            }

            @Generated
            public B result(CachedMetadataResolverResult result) {
                this.result = result;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "SamlRegisteredServiceDefaultCachingMetadataResolver.MetadataResolutionResult.MetadataResolutionResultBuilder(valid=" + this.valid + ", entityDescriptor=" + String.valueOf(this.entityDescriptor) + ", result=" + String.valueOf(this.result) + ")";
            }
        }

        @Generated
        private static final class MetadataResolutionResultBuilderImpl
        extends MetadataResolutionResultBuilder<MetadataResolutionResult, MetadataResolutionResultBuilderImpl> {
            @Generated
            private MetadataResolutionResultBuilderImpl() {
            }

            @Override
            @Generated
            protected MetadataResolutionResultBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public MetadataResolutionResult build() {
                return new MetadataResolutionResult(this);
            }
        }
    }

    static final class MetadataResolverCacheQueryResult {
        private final CachedMetadataResolverResult result;
        private final Optional<EntityDescriptor> entityDescriptor;

        public boolean isValid() {
            return this.result != null && this.result.isResolved();
        }

        @Generated
        private static Optional<EntityDescriptor> $default$entityDescriptor() {
            return Optional.empty();
        }

        @Generated
        protected MetadataResolverCacheQueryResult(MetadataResolverCacheQueryResultBuilder<?, ?> b) {
            this.result = b.result;
            this.entityDescriptor = b.entityDescriptor$set ? b.entityDescriptor$value : MetadataResolverCacheQueryResult.$default$entityDescriptor();
        }

        @Generated
        public static MetadataResolverCacheQueryResultBuilder<?, ?> builder() {
            return new MetadataResolverCacheQueryResultBuilderImpl();
        }

        @Generated
        public CachedMetadataResolverResult getResult() {
            return this.result;
        }

        @Generated
        public Optional<EntityDescriptor> getEntityDescriptor() {
            return this.entityDescriptor;
        }

        @Generated
        public static abstract class MetadataResolverCacheQueryResultBuilder<C extends MetadataResolverCacheQueryResult, B extends MetadataResolverCacheQueryResultBuilder<C, B>> {
            @Generated
            private CachedMetadataResolverResult result;
            @Generated
            private boolean entityDescriptor$set;
            @Generated
            private Optional<EntityDescriptor> entityDescriptor$value;

            @Generated
            public B result(CachedMetadataResolverResult result) {
                this.result = result;
                return this.self();
            }

            @Generated
            public B entityDescriptor(Optional<EntityDescriptor> entityDescriptor) {
                this.entityDescriptor$value = entityDescriptor;
                this.entityDescriptor$set = true;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "SamlRegisteredServiceDefaultCachingMetadataResolver.MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder(result=" + String.valueOf(this.result) + ", entityDescriptor$value=" + String.valueOf(this.entityDescriptor$value) + ")";
            }
        }

        @Generated
        private static final class MetadataResolverCacheQueryResultBuilderImpl
        extends MetadataResolverCacheQueryResultBuilder<MetadataResolverCacheQueryResult, MetadataResolverCacheQueryResultBuilderImpl> {
            @Generated
            private MetadataResolverCacheQueryResultBuilderImpl() {
            }

            @Override
            @Generated
            protected MetadataResolverCacheQueryResultBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public MetadataResolverCacheQueryResult build() {
                return new MetadataResolverCacheQueryResult(this);
            }
        }
    }
}

