/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.security.enterprise.identitystore.openid.RefreshToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.security.cdi.openid.TomEEOpenIdContext;
import org.apache.tomee.security.cdi.openid.storage.OpenIdStorageHandler;
import org.apache.tomee.security.http.SavedRequest;
import org.apache.tomee.security.http.openid.model.TokenResponse;
import org.apache.tomee.security.http.openid.model.TomEEOpenIdCredential;

@ApplicationScoped
public class OpenIdAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.TOMEE_SECURITY, OpenIdAuthenticationMechanism.class);
    @Inject
    private OpenIdAuthenticationMechanismDefinition definition;
    @Inject
    private IdentityStoreHandler identityStoreHandler;
    @Inject
    private TomEEOpenIdContext openIdContext;
    @Inject
    private OpenIdStorageHandler storageHandler;

    public void cleanSubject(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        if (this.definition.logout().notifyProvider()) {
            if (!this.definition.providerMetadata().endSessionEndpoint().isEmpty()) {
                UriBuilder endSession = UriBuilder.fromUri((String)this.definition.providerMetadata().endSessionEndpoint()).queryParam("id_token_hint", new Object[]{this.openIdContext.getIdentityToken().getToken()});
                if (!this.definition.logout().redirectURI().isEmpty()) {
                    endSession.queryParam("post_logout_redirect_uri", new Object[]{this.definition.logout().redirectURI()});
                }
                httpMessageContext.redirect(endSession.build(new Object[0]).toString());
                return;
            }
        } else if (!this.definition.logout().redirectURI().isEmpty()) {
            httpMessageContext.redirect(this.definition.logout().redirectURI());
            return;
        }
        this.redirectToAuthorization(request, response, httpMessageContext);
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        if (request.getUserPrincipal() != null) {
            AuthenticationStatus result = this.handleExpiredTokens(request, response, httpMessageContext);
            if (result != null) {
                return result;
            }
            CallerPrincipalCallback callerPrincipalCallback = new CallerPrincipalCallback(httpMessageContext.getClientSubject(), request.getUserPrincipal());
            try {
                httpMessageContext.getHandler().handle(new Callback[]{callerPrincipalCallback});
            }
            catch (IOException | UnsupportedCallbackException e) {
                LOGGER.error("Could not handle CallerPrincipalCallback", (Throwable)e);
            }
            return AuthenticationStatus.SUCCESS;
        }
        AuthenticationStatus result = this.performAuthentication(request, response, httpMessageContext);
        if (result != null) {
            return result;
        }
        return httpMessageContext.doNothing();
    }

    protected AuthenticationStatus handleExpiredTokens(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
        if (this.openIdContext.getAccessToken() != null && this.openIdContext.getAccessToken().isExpired()) {
            LOGGER.debug("access token did expire");
            if (this.definition.tokenAutoRefresh()) {
                LOGGER.debug("Attempting to refresh tokens after access token expiry");
                return this.refreshTokens(request, response, httpMessageContext);
            }
            if (this.definition.logout().accessTokenExpiry()) {
                LOGGER.debug("access token expired and accessTokenExpiry=true, performing logout");
                this.cleanSubject(request, response, httpMessageContext);
                return AuthenticationStatus.SEND_FAILURE;
            }
        }
        if (this.openIdContext.getIdentityToken() != null && this.openIdContext.getIdentityToken().isExpired()) {
            LOGGER.debug("identity token did expire");
            if (this.definition.tokenAutoRefresh()) {
                LOGGER.debug("Attempting to refresh tokens after identity token expiry");
                return this.refreshTokens(request, response, httpMessageContext);
            }
            if (this.definition.logout().identityTokenExpiry()) {
                LOGGER.debug("identity token expired and identityTokenExpiry=true, performing logout");
                this.cleanSubject(request, response, httpMessageContext);
                return AuthenticationStatus.SEND_FAILURE;
            }
        }
        return null;
    }

    protected AuthenticationStatus refreshTokens(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
        AuthenticationStatus authenticationStatus;
        block8: {
            Client client = ClientBuilder.newClient();
            try {
                RefreshToken refreshToken = this.openIdContext.getRefreshToken().orElseThrow(() -> new IllegalArgumentException("Cannot refresh tokens, no refresh_token received"));
                Form form = new Form().param("client_id", this.definition.clientId()).param("client_secret", this.definition.clientSecret()).param("grant_type", "refresh_token").param("refresh_token", refreshToken.getToken());
                TokenResponse tokenResponse = (TokenResponse)client.target(this.definition.providerMetadata().tokenEndpoint()).request().accept(new String[]{"application/json"}).post(Entity.form((Form)form), TokenResponse.class);
                authenticationStatus = this.handleTokenResponse(tokenResponse, httpMessageContext);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.cleanSubject(request, response, httpMessageContext);
                    throw e;
                }
            }
            client.close();
        }
        return authenticationStatus;
    }

    protected AuthenticationStatus redirectToAuthorization(HttpServletRequest request, HttpServletResponse response, HttpMessageContext messageContext) {
        Object fullRequestUrl = request.getRequestURL().toString();
        if (request.getQueryString() != null) {
            fullRequestUrl = (String)fullRequestUrl + "?" + request.getQueryString();
        }
        this.storageHandler.set(request, response, "oidc.original.request", (String)fullRequestUrl);
        this.storageHandler.set(request, response, "REQUEST", SavedRequest.fromRequest(request).toJson());
        return messageContext.redirect(this.buildAuthorizationUri(request, response).toString());
    }

    protected AuthenticationStatus performAuthentication(HttpServletRequest request, HttpServletResponse response, HttpMessageContext messageContext) {
        String state = request.getParameter("state");
        if (state == null && request.getUserPrincipal() == null && messageContext.isProtected()) {
            return this.redirectToAuthorization(request, response, messageContext);
        }
        if (state != null) {
            String originalRequest = this.storageHandler.get(request, response, "oidc.original.request");
            boolean matchesOriginalRequest = originalRequest.startsWith(request.getRequestURL().toString());
            if (!request.getRequestURL().toString().equals(this.definition.redirectURI()) && this.definition.redirectToOriginalResource() && !matchesOriginalRequest) {
                return messageContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
            }
            if (this.storageHandler.getStoredState(request, response) == null) {
                return messageContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
            }
            if (!state.equals(this.storageHandler.getStoredState(request, response))) {
                return messageContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
            }
            if (request.getParameter("error") != null) {
                return messageContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
            }
            if (this.definition.redirectToOriginalResource() && !matchesOriginalRequest) {
                return messageContext.redirect(this.appendQueryString(originalRequest, request.getQueryString()));
            }
            this.storageHandler.delete(request, response, "STATE");
            try (Client client = ClientBuilder.newClient();){
                Form form = new Form().param("client_id", this.definition.clientId()).param("client_secret", this.definition.clientSecret()).param("grant_type", "authorization_code").param("redirect_uri", this.definition.redirectURI()).param("code", request.getParameter("code"));
                TokenResponse tokenResponse = (TokenResponse)client.target(this.definition.providerMetadata().tokenEndpoint()).request().accept(new String[]{"application/json"}).post(Entity.form((Form)form), TokenResponse.class);
                AuthenticationStatus result = this.handleTokenResponse(tokenResponse, messageContext);
                if (this.definition.redirectToOriginalResource()) {
                    String originalRequestJson = this.storageHandler.get(request, response, "REQUEST");
                    messageContext.withRequest(SavedRequest.fromJson(originalRequestJson).mask(request));
                }
                this.storageHandler.delete(request, response, "NONCE");
                this.storageHandler.delete(request, response, "REQUEST");
                this.storageHandler.delete(request, response, "oidc.original.request");
                AuthenticationStatus authenticationStatus = result;
                return authenticationStatus;
            }
        }
        return null;
    }

    protected AuthenticationStatus handleTokenResponse(TokenResponse tokenResponse, HttpMessageContext httpMessageContext) {
        this.openIdContext.setExpiresIn(tokenResponse.getExpiresIn());
        this.openIdContext.setTokenType(tokenResponse.getTokenType());
        TomEEOpenIdCredential credential = new TomEEOpenIdCredential(tokenResponse, httpMessageContext);
        CredentialValidationResult validationResult = this.identityStoreHandler.validate((Credential)credential);
        httpMessageContext.setRegisterSession(validationResult.getCallerPrincipal().getName(), validationResult.getCallerGroups());
        return httpMessageContext.notifyContainerAboutLogin(validationResult);
    }

    protected URI buildAuthorizationUri(HttpServletRequest request, HttpServletResponse response) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.definition.providerMetadata().authorizationEndpoint()).queryParam("client_id", new Object[]{this.definition.clientId()}).queryParam("scope", new Object[]{String.join((CharSequence)" ", this.definition.scope())}).queryParam("response_type", new Object[]{this.definition.responseType()}).queryParam("state", new Object[]{this.storageHandler.createNewState(request, response)}).queryParam("redirect_uri", new Object[]{this.definition.redirectURI()});
        if (this.definition.useNonce()) {
            uriBuilder.queryParam("nonce", new Object[]{this.storageHandler.createNewNonce(request, response)});
        }
        if (!this.definition.responseMode().isEmpty()) {
            uriBuilder.queryParam("response_mode", new Object[]{this.definition.responseMode()});
        }
        if (this.definition.display() != null) {
            uriBuilder.queryParam("display", new Object[]{this.definition.display().name().toLowerCase()});
        }
        if (this.definition.prompt().length > 0) {
            String stringifiedPrompt = Arrays.stream(this.definition.prompt()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(" "));
            uriBuilder.queryParam("prompt", new Object[]{stringifiedPrompt});
        }
        for (String extraParam : this.definition.extraParameters()) {
            String[] paramParts = extraParam.split("=");
            if (paramParts.length != 2) {
                throw new IllegalArgumentException("extra parameter in invalid format, expected \"key=value\": " + extraParam);
            }
            uriBuilder.queryParam(paramParts[0], new Object[]{paramParts[1]});
        }
        return uriBuilder.build(new Object[0]);
    }

    protected String appendQueryString(String url, String query) {
        if (url.contains("?")) {
            return url + "&" + query;
        }
        return url + "?" + query;
    }
}

