/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.nio;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.ws.rs.container.AsyncResponse;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.nio.NioInputStream;
import org.apache.cxf.jaxrs.nio.NioReadEntity;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public final class NioReadListenerImpl
implements ReadListener {
    private static final Logger LOG = LogUtils.getL7dLogger(NioReadListenerImpl.class);
    private final NioReadEntity entity;
    private final NioInputStream in;

    public NioReadListenerImpl(NioReadEntity entity, ServletInputStream in) {
        this.entity = entity;
        this.in = new NioInputStream(in);
    }

    public void onDataAvailable() throws IOException {
        while (this.in.isReady() && !this.in.isFinished()) {
            this.entity.getReader().read(this.in);
        }
    }

    public void onAllDataRead() throws IOException {
        this.entity.getCompletion().complete();
    }

    public void onError(Throwable t) {
        if (this.entity.getError() == null) {
            this.getAsyncResponse().resume(t);
            return;
        }
        try {
            this.entity.getError().error(t);
        }
        catch (Throwable ex) {
            LOG.warning("NIO NioReadListener error: " + ExceptionUtils.getStackTrace(ex));
        }
    }

    private AsyncResponse getAsyncResponse() {
        return (AsyncResponse)JAXRSUtils.getCurrentMessage().getExchange().get(AsyncResponse.class);
    }
}

