/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import org.apache.openjpa.enhance.FieldManager;

class TransferFieldManager
implements FieldManager {
    protected double dblval = 0.0;
    protected long longval = 0L;
    protected Object objval = null;
    protected int field = -1;

    TransferFieldManager() {
    }

    @Override
    public boolean fetchBooleanField(int field) {
        return this.longval == 1L;
    }

    @Override
    public byte fetchByteField(int field) {
        return (byte)this.longval;
    }

    @Override
    public char fetchCharField(int field) {
        return (char)this.longval;
    }

    @Override
    public double fetchDoubleField(int field) {
        return this.dblval;
    }

    @Override
    public float fetchFloatField(int field) {
        return (float)this.dblval;
    }

    @Override
    public int fetchIntField(int field) {
        return (int)this.longval;
    }

    @Override
    public long fetchLongField(int field) {
        return this.longval;
    }

    @Override
    public Object fetchObjectField(int field) {
        return this.objval;
    }

    @Override
    public short fetchShortField(int field) {
        return (short)this.longval;
    }

    @Override
    public String fetchStringField(int field) {
        return (String)this.objval;
    }

    @Override
    public void storeBooleanField(int field, boolean curVal) {
        this.field = field;
        this.longval = curVal ? 1L : 0L;
    }

    @Override
    public void storeByteField(int field, byte curVal) {
        this.field = field;
        this.longval = curVal;
    }

    @Override
    public void storeCharField(int field, char curVal) {
        this.field = field;
        this.longval = curVal;
    }

    @Override
    public void storeDoubleField(int field, double curVal) {
        this.field = field;
        this.dblval = curVal;
    }

    @Override
    public void storeFloatField(int field, float curVal) {
        this.field = field;
        this.dblval = curVal;
    }

    @Override
    public void storeIntField(int field, int curVal) {
        this.field = field;
        this.longval = curVal;
    }

    @Override
    public void storeLongField(int field, long curVal) {
        this.field = field;
        this.longval = curVal;
    }

    @Override
    public void storeObjectField(int field, Object curVal) {
        this.field = field;
        this.objval = curVal;
    }

    @Override
    public void storeShortField(int field, short curVal) {
        this.field = field;
        this.longval = curVal;
    }

    @Override
    public void storeStringField(int field, String curVal) {
        this.field = field;
        this.objval = curVal;
    }

    public void clear() {
        this.dblval = 0.0;
        this.longval = 0L;
        this.objval = null;
        this.field = -1;
    }
}

