/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;

public class ExternalLink
extends AbstractLink {
    private static final long serialVersionUID = 1L;
    private boolean contextRelative = false;
    private PopupSettings popupSettings = null;

    public ExternalLink(String id, String href, String label) {
        super(id);
        this.setDefaultModel(href != null ? new Model<String>(href) : null);
        this.setBody(Model.of(label));
    }

    public ExternalLink(String id, String href) {
        this(id, (IModel<String>)Model.of(href));
    }

    public ExternalLink(String id, IModel<String> href) {
        this(id, href, null);
    }

    public ExternalLink(String id, IModel<String> href, IModel<?> label) {
        super(id);
        this.setDefaultModel((IModel)this.wrap(href));
        this.setBody(label);
    }

    public final PopupSettings getPopupSettings() {
        return this.popupSettings;
    }

    public final ExternalLink setPopupSettings(PopupSettings popupSettings) {
        this.popupSettings = popupSettings;
        return this;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        String url;
        super.onComponentTag(tag);
        if (!this.isEnabledInHierarchy()) {
            this.disableLink(tag);
        } else if (this.getDefaultModel() != null && (url = this.renderUrl()) != null && (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area"))) {
            tag.put("href", url);
        }
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (!this.isEnabledInHierarchy()) {
            return;
        }
        String url = this.renderUrl();
        if (url != null) {
            if (this.popupSettings != null) {
                this.popupSettings.setTarget("'" + url + "'");
                response.render(OnEventHeaderItem.forComponent(this, "click", this.popupSettings.getPopupJavaScript()));
                return;
            }
            ComponentTag tag = this.getMarkupTag();
            if (!(tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area") || tag.getName().equalsIgnoreCase("script") || tag.getName().equalsIgnoreCase("style"))) {
                response.render(OnEventHeaderItem.forComponent(this, "click", "var win = this.ownerDocument.defaultView || this.ownerDocument.parentWindow; if (win == window) { window.location.href='" + url + "'; } ;return false"));
                return;
            }
        }
    }

    private String renderUrl() {
        Object hrefValue = this.getDefaultModelObject();
        if (hrefValue == null) {
            return null;
        }
        String url = hrefValue.toString();
        if (this.contextRelative) {
            if (url.length() > 0 && url.charAt(0) == '/') {
                url = url.substring(1);
            }
            url = UrlUtils.rewriteToContextRelative((String)url, (IRequestCycle)RequestCycle.get());
        }
        return url;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public ExternalLink setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
        return this;
    }
}

