/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/**
 * Representing a Server Variable for server URL template substitution.
 */
#ifndef QtOAI_SERVERVARIABLE_H
#define QtOAI_SERVERVARIABLE_H

#include <QtCore/qset.h>
#include <QtCore/qstring.h>

namespace QtCommonOpenAPI {

class QtOAIServerVariable {
public:
    enum class ServerError
    {
        NoError = 0, // Success
        ServerVariableNotFound = -1,
        EnumValueNotFound = -2,   // The value is not defined in m_enumValues
        OperationNotFound = -3,
        ServerIndexNotFound = -4,
    };

    /**
     * @param description A description for the server variable.
     * @param defaultValue The default value to use for substitution.
     * @param enumValues An enumeration of string values to be used if the substitution options are from a limited set.
     */
    QtOAIServerVariable(const QString &description, const QString &defaultValue, const QSet<QString> &enumValues)
    : m_defaultValue(defaultValue),
      m_description(description),
      m_enumValues(enumValues) {}

    QtOAIServerVariable() {}
    ~QtOAIServerVariable() {}

    ServerError setDefaultValue(const QString& value) {
        if (!m_enumValues.empty() && !m_enumValues.contains(value))
            return ServerError::EnumValueNotFound;

        m_defaultValue = value;
        return ServerError::NoError;
    }

    QString getDefaultValue() { return m_defaultValue; }
    QSet<QString> getEnumValues() { return m_enumValues; }

    QString m_defaultValue;
    QString m_description;
    QSet<QString> m_enumValues;
};

} // namespace QtCommonOpenAPI

#endif // QtOAI_SERVERVARIABLE_H
