# frozen_string_literal: true

class RemoveIndexVulnerabilityExternalIssueLinksOnVulnerabilityId < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  disable_ddl_transaction!

  TABLE_NAME = :vulnerability_external_issue_links
  INDEX_NAME = 'index_vulnerability_external_issue_links_on_vulnerability_id'
  COLUMNS = %i[vulnerability_id]

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, COLUMNS, name: INDEX_NAME
  end
end
