---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'チュートリアル: チームスタンドアップ用のイシューボードをセットアップする'
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

<!-- vale gitlab_base.FutureTense = NO -->

このチュートリアルでは、チームが効果的なスタンドアップを実行するのに役立つイシューボードを作成および設定する方法について説明します。完了すると、このワークフローをサポートするボードが作成されます:

1. 各スタンドアップの前に:

   - チームメンバーは、割り当てられたタスクのステータスを更新します。
   - タスクは、現在の状態を示すリスト（計画、開発中、ブロック、完了）を移動します。

1. スタンドアップ中:

   - チームメンバーは、進行中の作業について話し合い、完了タイムラインを共有します。
   - ブロックされたタスクが特定され、それらを解決するための計画が立てられます。
   - 新しいタスクが準備完了リストに追加されます。
   - 完了したタスクを祝い、完了に移動します。

結果: チームは各スタンドアップで、スプリントの進捗状況に合わせて、リスクを特定し、それらに対処するための計画を立てます。

チームスタンドアップ用のイシューボードをセットアップするには、次のようにします:

1. [グループを作成する](#create-a-group)
1. [プロジェクトを作成する](#create-a-project)
1. [ラベルを作成](#create-labels)
1. [チームのスタンドアップボードを作成](#create-the-team-stand-up-board)
1. [ボードリストを設定](#configure-your-board-lists)
1. [チームのタスクのイシューを作成](#create-issues-for-team-tasks)

## はじめる前 {#before-you-begin}

- このチュートリアルで既存のグループを使用している場合は、少なくともグループのプランナーロールがあることを確認してください。
- このチュートリアルで既存のプロジェクトを使用している場合は、少なくともプロジェクトのプランナーロールがあることを確認してください。

## グループを作成する {#create-a-group}

まず、1つまたは複数の関連するプロジェクトを管理するためのグループを作成します。グループを使用すると、メンバーアクセスを管理し、プロジェクト間で設定を共有できます。

グループを作成するには:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規グループ**を選択します。
1. **グループを作成**を選択します。
1. フィールドに入力します:
   - **グループ名**に`Paperclip Software Factory`と入力します。
1. **グループを作成**を選択します。

空のグループを作成しました。次に、イシューとコードを保存するためのプロジェクトを作成します。

## プロジェクトを作成する {#create-a-project}

プロジェクトには、コードリポジトリと、計画に使用するイシューが保存されます。すべての開発作業はプロジェクトで行われます。

空のプロジェクトを作成するには: 

1. グループの右上隅で、**新規プロジェクト**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. フィールドに入力します:
   - **プロジェクト名**に、`Paperclip Assistant`と入力します。
1. **プロジェクトを作成**を選択します。

## ラベルを作成 {#create-labels}

スタンドアップ中にイシューのステータスを追跡するには、ワークフローのラベルが必要です。

これらのラベルは、プロジェクトではなく、`Paperclip Software Factory`グループに作成します。グループレベルのラベルは、グループ内のすべてのプロジェクトで使用でき、チーム全体で一貫性のあるワークフローを確立するのに役立ちます。

ワークフローのラベルを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択し、**Paperclip Software Factory**（ペーパークリップソフトウェアファクトリー） グループを見つけます。
1. **管理** > **ラベル**を選択します。
1. **新しいラベル**を選択します。
1. **タイトル**フィールドに、ラベル名を入力します。
1. オプション。背景色を選択するか、16進数のカラー値を入力します。
1. **ラベルを作成**を選択します。

これらの手順を繰り返して、すべてのワークフローのラベルを作成します:

- `workflow::planning breakdown`
- `workflow::ready for development`
- `workflow::in development`
- `workflow::ready for review`
- `workflow::in review`
- `workflow::blocked`
- `workflow::verification`
- `workflow::complete`

## チームのスタンドアップボードを作成 {#create-the-team-stand-up-board}

グループのボードを作成して、グループ内の任意のプロジェクトからイシューを管理できるようにします。

グループイシューボードを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択し、**Paperclip Software Factory**（ペーパークリップソフトウェアファクトリー） グループを見つけます。
1. **Plan** > **イシューボード**を選択します。
1. 左上隅で、現在のボード名を持つドロップダウンリストを選択します。
1. **新しいボードを作成する**を選択します。
1. フィールドに入力します:
   - **タイトル**に、`Team stand-up`を入力します。
   - **オープンリストを表示する**と**クローズドリストを表示する**の両方を選択します。
1. **ボードを作成する**を選択します。

### ボードにワークフローリストを追加 {#add-workflow-lists-to-your-board}

1. 右上隅で、**Add list**（リストを追加） ({{< icon name="plus" >}}) を選択します。
1. **新しいリスト**から、**ラベル**を選択します。
1. **値**ドロップダウンリストから、ワークフローのラベルを選択します。
1. **ボードに追加**を選択します。
1. 各ワークフローのラベルについて、手順1〜4を繰り返します。

ボードに、各ワークフローの状態のリストが表示されるようになりました。ただし、後の手順でイシューを追加するまでは空になります。

![イシューボード「チームのスタンドアップ」という名前で、ワークフローリストはあるが、イシューはない](img/team_standup_board_with_workflow_lists_v17_8.png)

## ボードリストを設定 {#configure-your-board-lists}

すべてのリストに適用されるフィルターを設定して、ボードをカスタマイズできます。たとえば、現在のイテレーションまたは特定のラベルからのイシューのみを表示できます。

ボードを設定するには:

1. チームのスタンドアップボードで、**ボードを設定する** ({{< icon name="settings" >}}) を選択します。
1. これらのフィールドのいずれかを入力して、イシューをフィルターします:
   - **マイルストーン**: 特定のマイルストーンからのイシューを表示します。
   - **担当者**: 特定のチームメンバーに割り当てられたイシューを表示します。
   - **ラベル**: 特定のラベルを持つイシューを表示します。
   - **ウェイト**: 特定のウェイト値を持つイシューを表示します。
   - **イテレーション**: 現在のイテレーションからのイシューを表示します。
1. **ボードを作成する**を選択します。

ボードに、フィルターに一致するイシューのみが表示されるようになりました。たとえば、マイルストーンを選択すると、そのマイルストーンに割り当てられたイシューのみがボードリストに表示されます。

![イシューボード「チームのスタンドアップ」という名前で、ワークフローリストがある](img/team_standup_board_with_workflow_lists_v17_8.png)

## チームのタスクのイシューを作成 {#create-issues-for-team-tasks}

チームのスタンドアップ中に、ボードから直接イシューを作成できます。

イシューを作成するには:

1. チームのスタンドアップボードの`workflow::ready for development`リストで、**イシューの新規作成** ({{< icon name="plus" >}}) を選択します。
1. フィールドに入力します:
   - **タイトル**に、`Redesign user profile page`を入力します
   - **プロジェクト**ドロップダウンリストから、**Paperclip Software Factory / Paperclip Assistant**（ペーパークリップソフトウェアファクトリー / ペーパークリップアシスタント）を選択します
1. **イシューの作成**を選択します。

そのリストで作成したため、`workflow::ready for development`ラベルがイシューに作成されます。

### イシューにメタデータを追加 {#add-metadata-to-the-issue}

1. イシューカードで、タイトル以外の任意の場所を選択します。
1. 右側のサイドバーで、更新するフィールドの**編集**を選択します。
1. 変更を選択します。
1. フィールドの外側の任意の領域を選択して保存します。

おつかれさまでした。作業の追跡とディスカッションの促進に役立つ、チームのスタンドアップボードを設定しました。チームは、このボードを使用して、効果的なスタンドアップを実行できるようになりました。

## 関連トピック {#related-topics}

- [作業の計画と追跡のチュートリアル](../plan_and_track.md)。
- [スタンドアップ、レトロスペクティブ、ベロシティ](../scrum_events/standups_retrospectives_velocity.md)
