---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 承認ルールを使用して、マージリクエストを承認する必要のあるユーザーまたはグループを定義します。承認者は、オプションまたは必須にできます。
title: マージリクエスト承認ルール
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

承認ルールでは、マージリクエストをマージする前に必要な[承認](_index.md)の数と、承認を行うユーザーを定義します。これらを[コードオーナー](#code-owners-as-approvers)と組み合わせて使用することで、機能の保守を行うグループと、特定の監視領域を担当するすべてのグループによる変更のレビューを確実にできます。

承認ルールは、次のように定義できます:

- [プロジェクトのデフォルトとして](#add-an-approval-rule)。
- [マージリクエストごと](#edit-or-override-merge-request-approval-rules)。

承認ルールは、次のように設定できます:

- [インスタンス全体に対して](../../../../administration/merge_requests_approvals.md)。

[デフォルトの承認ルール](#add-an-approval-rule)を定義しない場合、どのユーザーでもマージリクエストを承認できます。ルールを定義しない場合でも、プロジェクトの設定で[必要な承認者の最小数](settings.md)を適用できます。

フォークからアップストリームプロジェクトなど、別のプロジェクトを対象とするマージリクエストは、ソース（フォーク）ではなく、ターゲット（アップストリーム）プロジェクトからのデフォルトの承認ルールを使用します。

[ポリシー](../../../application_security/policies/_index.md)を使用して、すべてのプロジェクトに適用するようにマージリクエストの承認をグローバルに設定できます。[マージリクエスト承認ポリシー](../../../application_security/policies/merge_request_approval_policies.md)では、よりきめ細かい設定オプションを使用して、柔軟性を高めることもできます。

## 承認ルールを追加する {#add-an-approval-rule}

前提要件:

- プロジェクトのメンテナーロール以上を持っている必要があります。
- GitLab.comでグループを承認者として追加するには、そのグループのメンバーであるか、グループが公開されている必要があります。

マージリクエスト承認ルールを追加するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージリクエストの承認**セクションの**承認ルール**セクションで、**承認ルールを追加**を選択します。
1. 右側のサイドバーで、次のフィールドに入力します:
   - **承認が必要**で、`0`の値は[ルールをオプション](#configure-optional-approval-rules)にし、`0`より大きい数値を指定すると必須ルールが作成されます。必要な承認の最大数は`100`です。
   - **承認者を追加**から、[承認を受ける資格がある](#eligible-approvers)ユーザーまたはグループを選択します。GitLabは、マージリクエストによって変更されたファイルの以前の作成者に基づいて承認者を提案します。
1. **変更を保存**を選択します。[複数の承認ルール](#multiple-approval-rules)を追加できます。

承認ルールの上書きの設定によって、新しいルールが既存のマージリクエストに適用されるかどうかが決まります:

- [承認ルールの上書き](settings.md#prevent-editing-approval-rules-in-merge-requests)が許可されている場合、これらのデフォルトルールへの変更は、ルールの[ターゲットブランチ](#approvals-for-protected-branches)への変更を除き、既存のマージリクエストには適用されません。
- 承認ルールの上書きが許可されていない場合、デフォルトルールへのすべての変更が既存のマージリクエストに適用されます。承認ルールの上書きが許可されていた期間中に以前に手動で[上書き](#edit-or-override-merge-request-approval-rules)された承認ルールは、変更されません。

## 承認ルールを編集する {#edit-an-approval-rule}

前提要件:

- プロジェクトのメンテナーロール以上を持っている必要があります。
- GitLab.comでグループを承認者として追加するには、そのグループのメンバーであるか、グループが公開されている必要があります。

マージリクエスト承認ルールを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージリクエストの承認**セクションの**承認ルール**セクションで、編集するルールの横にある**編集**を選択します。
1. 右側のサイドバーで、フィールドを編集します:
   - **承認が必要**で、`0`の値は[ルールをオプション](#configure-optional-approval-rules)にし、`0`より大きい数値を指定すると必須ルールが作成されます。必要な承認の最大数は`100`です。
   - ユーザーまたはグループを削除するには、削除するグループまたはユーザーを特定し、**削除**（{{< icon name="remove" >}}）を選択します。
1. **変更を保存**を選択します。

## 承認ルールを削除する {#delete-an-approval-rule}

前提要件:

- プロジェクトのメンテナーロール以上を持っている必要があります。

マージリクエスト承認ルールを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージリクエストの承認**セクションで、削除するルールの横にあるゴミ箱（{{< icon name="remove" >}}）を選択します。
1. **承認者を削除**を選択します。

## 複数の承認ルール {#multiple-approval-rules}

マージリクエストで複数の承認ルールを適用するには、プロジェクトに複数のデフォルト承認ルールを追加します。

[適格な承認者](#eligible-approvers)がマージリクエストを承認すると、承認者が属するすべてのルールについて、残りの承認数（**承認**列）が減少します:

![マージリクエスト承認ウィジェット](img/mr_approvals_widget_v16_0.png)

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、[複数の承認者](https://www.youtube.com/watch?v=8JQJ5821FrA)を参照してください。

## 承認できるすべてのマージリクエストに関する通知を受け取る {#get-notified-about-all-merge-requests-you-can-approve}

承認できるマージリクエストが作成されるたびにメール通知を受け取るには:

- [通知レベルの設定](../../../profile/notifications.md#edit-notification-settings)を**カスタム**に設定し、**あなたの承認が適格なマージリクエストが作成されました**イベントを選択します。

## マージリクエスト承認ルールを編集または上書きする {#edit-or-override-merge-request-approval-rules}

次のいずれかの方法で、プロジェクトのマージリクエスト承認ルールを上書きできます:

- 既存のマージリクエストを編集します。
- 新しいマージリクエストを作成します。

前提要件: 

- プロジェクト設定[承認ルールの編集を禁止](settings.md#prevent-editing-approval-rules-in-merge-requests)が無効になっています。
- 次のいずれかがtrueである必要があります:
  - 管理者アクセス権が必要です。
  - 自分がマージリクエストの作成者であり、プロジェクトで少なくともデベロッパーロールを持っている必要があります。
  - プロジェクトのメンテナー以上のロールを持っている必要があります。

マージリクエストの承認者を上書きするには:

1. [新しいマージリクエストを作成](../creating_merge_requests.md)するときは、**承認ルール**セクションまでスクロールし、**マージリクエストを作成**を選択する前に、目的の承認ルールを追加または削除します。
1. 既存のマージリクエストを表示する場合:
   1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
   1. **コード** > **マージリクエスト**を選択して、マージリクエストを見つけます。
   1. **編集**を選択します。
   1. **承認ルール**セクションまでスクロールします。
   1. 目的の承認ルールを追加または削除します。
   1. **変更を保存**を選択します。

管理者は、[マージリクエスト承認設定](settings.md#prevent-editing-approval-rules-in-merge-requests)を変更して、ユーザーがマージリクエストの承認ルールを上書きできないようにすることができます。

## ルールに必要な複数の承認を要求する {#require-multiple-approvals-for-a-rule}

複数の承認を必要とする承認ルールを作成するには:

- [ルールを作成](#add-an-approval-rule)または[編集](#edit-an-approval-rule)するときは、**承認が必要**を`2`以上に設定します。

ルールに必要な複数の承認を要求するには、[APIを使用](../../../../api/merge_request_approvals.md#update-an-approval-rule-for-a-project)して、`approvals_required`属性を`2`以上に設定することもできます。

## オプションの承認ルールを設定する {#configure-optional-approval-rules}

マージリクエストの承認は、承認は評価されるが必須ではないプロジェクトではオプションにできます。承認ルールをオプションにするには:

- [ルールを作成または編集する](#edit-an-approval-rule)ときは、**承認が必要**を`0`に設定します。

承認ルールをオプションにするには、APIを使用して[プロジェクトの承認ルールを更新](../../../../api/merge_request_approvals.md#update-an-approval-rule-for-a-project)し、`approvals_required`属性を`0`に設定することもできます。

## 保護ブランチの承認 {#approvals-for-protected-branches}

承認ルールは、[デフォルトブランチ](../../repository/branches/default.md)など、特定のブランチにのみ関連する場合がよくあります。特定のブランチの承認ルールを設定するには:

1. [承認ルールを作成](#add-an-approval-rule)します。
1. プロジェクトに移動し、**設定** > **マージリクエスト**を選択します。
1. **マージリクエストの承認**セクションで、**承認ルール**までスクロールします。
1. **ターゲットブランチ**の場合:
   - ルールをすべての保護ブランチに適用するには、**全ての保護ブランチ**を選択します。
   - ルールを特定のブランチに適用するには、リストからそれを選択します。
1. この設定を有効にするには、[保護ブランチでコードオーナーの承認を要求](../../repository/branches/protected.md#require-code-owner-approval)に従います。

## 追加ユーザーの承認権限を有効にする {#enable-approval-permissions-for-additional-users}

レポーターまたはプランナーロールを持つユーザーが保護ブランチにマージするには、マージリクエストを承認する権限を付与する必要がある場合があります。一部のユーザー（マネージャーなど）は、コードをプッシュまたはマージする権限を必要としない場合がありますが、提案された作業に対する監視は依然として必要です。

プランナーまたはレポーターロールを持つユーザーは、通常承認ルールを通じてのみマージリクエストを承認できます。コードオーナー承認ルールでは、ユーザーが少なくともデベロッパーロールを持っている必要があります。詳細については、[対象となる承認者](#eligible-approvers)を参照してください。

前提要件: 

- この方法は機能しないため、`All Branches`または`All protected branches`の設定で機能するため、特定のブランチを選択する必要があります。
- 追加されたユーザーがグループの一員であっても、共有グループは個々のユーザーではなく承認ルールに追加する必要があります。

プッシュアクセスを付与せずにこれらのユーザーの承認権限を有効にするには:

1. [保護ブランチを作成します](../../repository/branches/protected.md)
1. 承認権限を必要とするプランナーまたはレポーターロールを持つユーザーの[新しいグループを作成](../../../group/_index.md#create-a-group)します。
1. ユーザーを[グループに追加](../../../group/_index.md#add-users-to-a-group)します。ユーザーには、少なくともプランナーのロールが必要です。
1. 少なくともレポーターロールで、[グループとプロジェクトを共有](../../members/sharing_projects_groups.md#invite-a-group-to-a-project)します。
1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージリクエストの承認**セクションの**承認ルール**セクションで:
   - 新しいルールについては、**承認ルールを追加**を選択し、保護ブランチをターゲットにします。
   - 既存のルールについては、**編集**を選択し、保護ブランチをターゲットにします。
1. 右側のサイドバーの**承認者を追加**で、作成したグループを選択します。
1. **変更を保存**を選択します。

## セキュリティ承認 {#security-approvals}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 承認のボットコメントは、GitLab 16.2で`security_policy_approval_notification`[フラグ](../../../../administration/feature_flags/_index.md)ともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/411656)されました。デフォルトでは有効になっています。
- 承認のボットコメントは、GitLab 16.3で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130827)になりました。機能フラグ`security_policy_approval_notification`は削除されました。

{{< /history >}}

[マージリクエスト承認ポリシー](../../../application_security/policies/merge_request_approval_policies.md#merge-request-approval-policy-editor)を使用すると、マージリクエストとデフォルトブランチの脆弱性の状態に基づいてセキュリティ承認を定義できます。各セキュリティポリシーの詳細は、マージリクエスト設定の[セキュリティ承認]セクションに表示されます。

セキュリティ承認ルールは、パイプラインが完了するまですべてのマージリクエストに適用されます。セキュリティ承認ルールの適用により、ユーザーはセキュリティスキャンが実行される前にコードをマージできなくなります。パイプラインが完了すると、セキュリティ承認ルールがチェックされ、セキュリティ承認がまだ必要かどうかが判断されます。パイプライン内のスキャナーがイシューを特定し、セキュリティ承認が必要な場合、マージリクエストにボットコメントが生成され、続行するために必要な手順が示されます。

![セキュリティ承認](img/security_approvals_v15_0.png)

これらのポリシーは、[セキュリティポリシーエディタ](../../../application_security/policies/_index.md#policy-editor)で作成および編集されます。

## 適格な承認者 {#eligible-approvers}

プロジェクトの承認者としての資格を得るには、ユーザーは次のいずれかの直接のメンバーである必要があります:

- 自分のプロジェクト。
- プロジェクトのグループ。
- 自分のプロジェクトのグループの親グループのいずれか。
- [プロジェクトと共有されている](../../members/sharing_projects_groups.md#sharing-projects)別のグループ。
- [自分のプロジェクトのグループ、またはグループの親のいずれかと共有されている](../../members/sharing_projects_groups.md#sharing-groups)別のグループ。
- [承認者として追加されたグループ](#group-approvers)。

デベロッパーロールを持つユーザーは、次のいずれかに該当する場合、マージリクエストを承認できます:

- プロジェクトまたはマージリクエストレベルで承認者として追加されたユーザー。
- マージリクエストで変更されたファイルの[コードオーナー](#code-owners-as-approvers)であるユーザー。

プランナーまたはレポーターロールを持つユーザーが承認できるのは、次のすべてがtrueである場合のみです:

- ユーザーは、プロジェクトと[共有](../../members/sharing_projects_groups.md)されているグループの一員である必要があります。グループは、少なくともレポーターロールを持っている必要があります。
- プランナーおよびレポーターロールを持つユーザーの承認権限[が有効](#enable-approval-permissions-for-additional-users)になっている。

マージリクエストのレビューに参加したユーザーを表示するために、マージリクエストの承認ウィジェットには、**コメント投稿者**列が表示されます。この列には、マージリクエストにコメントした、適格な承認者が一覧表示されます。これにより、作成者とレビュアーは、マージリクエストの内容に関する質問について誰に連絡すればよいかを特定できます。

必要な承認の数が割り当て済みの承認者の数よりも多い場合、プロジェクトで少なくともデベロッパーロールを持つ他のユーザーからの承認は、ユーザーが承認ルールに明示的にリストされていなくても、必要な承認数を満たすためにカウントされます。

### コードオーナーを承認者として {#code-owners-as-approvers}

[コードオーナー](../../codeowners/_index.md)をリポジトリに追加すると、ファイルのオーナーがプロジェクトで適格な承認者になります。このマージリクエスト承認ルールを有効にするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージリクエストの承認**セクションの**承認ルール**セクションで、**All eligible users**（すべての対象ユーザー）ルールを見つけます。
1. **承認が必要**列に、必要な承認の数を入力します。

保護ブランチに対して[コードオーナーの承認を要求](../../repository/branches/protected.md#require-code-owner-approval)することもできます。

### メンバーシップタイプ別の承認者 {#approver-by-membership-type}

次の表は、メンバーシップタイプが承認ルールとコードオーナーの両方の対象にどのように影響するかを示しています。

#### ユーザーの適格性 {#user-eligibility}

承認ルールの承認者として個々のユーザーを割り当てる場合、または`CODEOWNERS`ファイルで`@username`のようにユーザーを参照する場合:

| メンバーシップの種類                                                                                                    | 承認ルール                              | GitLabコードオーナー                                 |
|--------------------------------------------------------------------------------------------------------------------|---------------------------------------------|---------------------------------------------|
| プロジェクトの直接メンバー                                                                                       | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| プロジェクトのグループの直接メンバー                                                                               | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| プロジェクトのグループの継承メンバー                                                                            | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| [プロジェクトに招待されたグループ](../../members/sharing_projects_groups.md#sharing-projects)の直接メンバー       | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| プロジェクトに招待されたグループの継承メンバー                                                                 | {{< icon name="dash-circle" >}}不可          | {{< icon name="dash-circle" >}}不可          |
| [プロジェクトのグループに招待されたグループ](../../members/sharing_projects_groups.md#sharing-groups)の直接メンバー | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| プロジェクトのグループに招待されたグループの継承メンバー                                                         | {{< icon name="dash-circle" >}}不可          | {{< icon name="dash-circle" >}}不可          |
| プロジェクトのグループのグループの親グループに招待されたグループの直接メンバー                                            | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| プロジェクトのグループのグループの親グループに招待されたグループの継承メンバー                                         | {{< icon name="dash-circle" >}}不可          | {{< icon name="dash-circle" >}}不可          |

#### グループの適格性 {#group-eligibility}

承認ルールの承認者としてグループを割り当てる場合、または`CODEOWNERS`ファイルで`@group-name`のようにグループを参照する場合、対象となるグループの直接メンバーのみが承認を提供できます:

| グループのタイプ                                                                                       | 承認ルール                              | GitLabコードオーナー                                 |
|--------------------------------------------------------------------------------------------------|---------------------------------------------|---------------------------------------------|
| [プロジェクトに招待されたグループ](../../members/sharing_projects_groups.md#sharing-projects)       | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| [プロジェクトのグループに招待されたグループ](../../members/sharing_projects_groups.md#sharing-groups) | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="dash-circle" >}}不可          |
| プロジェクトのグループの親に招待されたグループ                                                | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="dash-circle" >}}不可          |
| プロジェクトのグループ                                                                              | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| プロジェクトのグループの親                                                                  | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |

{{< alert type="note" >}}

グループベースの承認の場合、グループの直接メンバーのみがマージリクエストを承認できます。対象グループの継承メンバーは承認を提供できません。

{{< /alert >}}

### グループ承認者 {#group-approvers}

ユーザーのグループを承認者として追加できます。このグループのすべての直接のメンバーは、ルールを承認できます。継承されたメンバーは、ルールを承認できません。

通常、グループは最上位のネームスペースのサブグループですが、外部グループとコラボレーションしている場合は除きます。別のグループと連携していて、そのグループのメンバーを承認者として使用したい場合は、次のいずれかを行うことができます:

- [プロジェクトへのアクセスを共有](../../members/sharing_projects_groups.md#sharing-projects)。
- [プロジェクトのグループへのアクセスを共有](../../members/sharing_projects_groups.md#sharing-groups)。これにより、外部グループはプロジェクトのグループ内のすべてのプロジェクトへの承認アクセス権を取得します。

承認者グループにおけるユーザーのメンバーシップは、次の方法で個々の承認権限を決定します:

- 継承されたメンバーは、承認者とは見なされません。直接のメンバーのみがマージリクエストを承認できます。
- 後で個人承認者としても追加される、グループ承認者グループのユーザーは、2人ではなく、1人の承認者としてカウントされます。
- マージリクエストの作成者は、デフォルトでは、自分のマージリクエストの適格な承認者としてカウントされません。この動作を変更するには、[**Prevent merge request creator approval**（マージリクエスト作成者の承認を禁止）](settings.md#prevent-approval-by-merge-request-creator)プロジェクト設定を無効にします。
- マージリクエストへのコミッターは、マージリクエストを承認できます。この動作を変更するには、[**Prevent committers approval**（コミッターの承認を禁止）](settings.md#prevent-approvals-by-users-who-add-commits)プロジェクト設定を有効にします。

## トラブルシューティング {#troubleshooting}

### 承認ルール名は空白にできない {#approval-rule-name-cant-be-blank}

この検証エラーの回避策として、APIを使用して承認ルールを削除できます。

1. [プロジェクトのすべての承認ルールをリスト](../../../../api/merge_request_approvals.md#list-all-approval-rules-for-a-project)します。
1. [ルールを削除します](../../../../api/merge_request_approvals.md#delete-an-approval-rule-for-a-project)。

この検証エラーの詳細については、[イシュー285129](https://gitlab.com/gitlab-org/gitlab/-/issues/285129)をお読みください。

### グループは、プロジェクトに対する明示的または継承されたデベロッパーロールを必要とする {#groups-need-explicit-or-inherited-developer-role-on-a-project}

承認を処理するために作成されたグループは、レビューを必要とするプロジェクトとは異なるプロジェクト階層の領域に作成される場合があります。この場合、グループのメンバーは、アクセス権がないため、マージリクエストを承認する権限がない可能性があります。

次に例を示します:

以下のグループ構造では、プロジェクト1はサブグループ1に属し、サブグループ4にはユーザーがいます。

![シナリオの例 - プロジェクトとグループの階層](img/group_access_example_01_v16_8.png)

プロジェクト1は、プロジェクトの承認ルールを設定しており、サブグループ4を承認者として割り当てています。マージリクエストが作成されると、サブグループ4の承認者が、適格な承認者のリストに表示されます。ただし、サブグループ4のユーザーはマージリクエストを表示する権限がないため、`404`エラーが返されます。メンバーシップを付与するには、グループをプロジェクトメンバーとして招待する必要があります。これで、サブグループ4のユーザーが承認できるようになりました。

![プロジェクトメンバーページにサブグループ4がメンバーとして表示されています](img/group_access_example_02_v16_8.png)
