---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Slack webhook'
---

## Description

The response body contains content that matches the pattern of a Slack webhook URL was detected. Slack webhook URLs are used to post messages from external sources into Slack. They make use of HTTP requests with a JSON payload, which includes the message and a few other optional details. You can include message attachments to display richly-formatted messages. A malicious actor with access to this URL can post messages to the Slack channel it is bound to.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate the Slack webhook URL:

- Sign in to Slack and access <https://api.slack.com/apps>
- Find the application with the identified webhook URL and select the name
- In the left-hand menu, select "Incoming Webhooks"
- In the "Webhook URL" table, select the trash icon next to the webhook URL that was identified.
- When prompted, select "Remove" in the confirmation dialog

For more information, please see [Slack's documentation on webhooks](https://api.slack.com/messaging/webhooks).

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.110 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
