/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.messaging;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.CapturedMessageHeadersUtil;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import java.util.List;
import javax.annotation.Nullable;

public final class MessagingAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<Long> MESSAGING_BATCH_MESSAGE_COUNT = AttributeKey.longKey((String)"messaging.batch.message_count");
    private static final AttributeKey<String> MESSAGING_CLIENT_ID = AttributeKey.stringKey((String)"messaging.client_id");
    private static final AttributeKey<Boolean> MESSAGING_DESTINATION_ANONYMOUS = AttributeKey.booleanKey((String)"messaging.destination.anonymous");
    private static final AttributeKey<String> MESSAGING_DESTINATION_NAME = AttributeKey.stringKey((String)"messaging.destination.name");
    private static final AttributeKey<String> MESSAGING_DESTINATION_PARTITION_ID = AttributeKey.stringKey((String)"messaging.destination.partition.id");
    private static final AttributeKey<String> MESSAGING_DESTINATION_TEMPLATE = AttributeKey.stringKey((String)"messaging.destination.template");
    private static final AttributeKey<Boolean> MESSAGING_DESTINATION_TEMPORARY = AttributeKey.booleanKey((String)"messaging.destination.temporary");
    private static final AttributeKey<Long> MESSAGING_MESSAGE_BODY_SIZE = AttributeKey.longKey((String)"messaging.message.body.size");
    private static final AttributeKey<String> MESSAGING_MESSAGE_CONVERSATION_ID = AttributeKey.stringKey((String)"messaging.message.conversation_id");
    private static final AttributeKey<Long> MESSAGING_MESSAGE_ENVELOPE_SIZE = AttributeKey.longKey((String)"messaging.message.envelope.size");
    private static final AttributeKey<String> MESSAGING_MESSAGE_ID = AttributeKey.stringKey((String)"messaging.message.id");
    private static final AttributeKey<String> MESSAGING_OPERATION = AttributeKey.stringKey((String)"messaging.operation");
    private static final AttributeKey<String> MESSAGING_SYSTEM = AttributeKey.stringKey((String)"messaging.system");
    static final String TEMP_DESTINATION_NAME = "(temporary)";
    private final MessagingAttributesGetter<REQUEST, RESPONSE> getter;
    private final MessageOperation operation;
    private final List<String> capturedHeaders;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return MessagingAttributesExtractor.builder(getter, operation).build();
    }

    public static <REQUEST, RESPONSE> MessagingAttributesExtractorBuilder<REQUEST, RESPONSE> builder(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return new MessagingAttributesExtractorBuilder<REQUEST, RESPONSE>(getter, operation);
    }

    MessagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation, List<String> capturedHeaders) {
        this.getter = getter;
        this.operation = operation;
        this.capturedHeaders = CapturedMessageHeadersUtil.lowercase(capturedHeaders);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_SYSTEM, (Object)this.getter.getSystem(request));
        boolean isTemporaryDestination = this.getter.isTemporaryDestination(request);
        if (isTemporaryDestination) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_DESTINATION_TEMPORARY, (Object)true);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_DESTINATION_NAME, (Object)TEMP_DESTINATION_NAME);
        } else {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_DESTINATION_NAME, (Object)this.getter.getDestination(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_DESTINATION_TEMPLATE, (Object)this.getter.getDestinationTemplate(request));
        }
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_DESTINATION_PARTITION_ID, (Object)this.getter.getDestinationPartitionId(request));
        boolean isAnonymousDestination = this.getter.isAnonymousDestination(request);
        if (isAnonymousDestination) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_DESTINATION_ANONYMOUS, (Object)true);
        }
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_MESSAGE_CONVERSATION_ID, (Object)this.getter.getConversationId(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_MESSAGE_BODY_SIZE, (Object)this.getter.getMessageBodySize(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_MESSAGE_ENVELOPE_SIZE, (Object)this.getter.getMessageEnvelopeSize(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_CLIENT_ID, (Object)this.getter.getClientId(request));
        if (this.operation != null) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_OPERATION, (Object)this.operation.operationName());
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_MESSAGE_ID, (Object)this.getter.getMessageId(request, response));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_BATCH_MESSAGE_COUNT, (Object)this.getter.getBatchMessageCount(request, response));
        for (String name : this.capturedHeaders) {
            List<String> values = this.getter.getMessageHeader(request, name);
            if (values.isEmpty()) continue;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedMessageHeadersUtil.attributeKey(name), values);
        }
    }

    public SpanKey internalGetSpanKey() {
        if (this.operation == null) {
            return null;
        }
        switch (this.operation) {
            case PUBLISH: {
                return SpanKey.PRODUCER;
            }
            case RECEIVE: {
                return SpanKey.CONSUMER_RECEIVE;
            }
            case PROCESS: {
                return SpanKey.CONSUMER_PROCESS;
            }
        }
        throw new IllegalStateException("Can't possibly happen");
    }
}

