/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.media;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;

public abstract class AbstractSchema
extends BaseExtensibleModel<Schema>
implements Schema {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    protected Schema filter(OASFilter filter) {
        return filter.filterSchema((Schema)this);
    }

    public Schema getAdditionalPropertiesSchema() {
        return (Schema)this.getProperty("additionalProperties", Schema.class);
    }

    public void setAdditionalPropertiesSchema(Schema newValue) {
        this.setProperty("additionalProperties", newValue);
    }

    public List<Schema> getAllOf() {
        return this.getListProperty("allOf");
    }

    public void setAllOf(List<Schema> newValue) {
        this.setListProperty("allOf", newValue);
    }

    public AbstractSchema addAllOf(Schema newValue) {
        this.addListPropertyEntry("allOf", newValue);
        return this;
    }

    public void removeAllOf(Schema value) {
        this.removeListPropertyEntry("allOf", value);
    }

    public List<Schema> getAnyOf() {
        return this.getListProperty("anyOf");
    }

    public void setAnyOf(List<Schema> newValue) {
        this.setListProperty("anyOf", newValue);
    }

    public AbstractSchema addAnyOf(Schema newValue) {
        this.addListPropertyEntry("anyOf", newValue);
        return this;
    }

    public void removeAnyOf(Schema value) {
        this.removeListPropertyEntry("anyOf", value);
    }

    public String getComment() {
        return (String)this.getProperty("$comment", String.class);
    }

    public void setComment(String newValue) {
        this.setProperty("$comment", newValue);
    }

    public Object getConstValue() {
        return this.getProperty("const", Object.class);
    }

    public void setConstValue(Object newValue) {
        this.setProperty("const", newValue);
    }

    public Schema getContains() {
        return (Schema)this.getProperty("contains", Schema.class);
    }

    public void setContains(Schema newValue) {
        this.setProperty("contains", newValue);
    }

    public String getContentEncoding() {
        return (String)this.getProperty("contentEncoding", String.class);
    }

    public void setContentEncoding(String newValue) {
        this.setProperty("contentEncoding", newValue);
    }

    public String getContentMediaType() {
        return (String)this.getProperty("contentMediaType", String.class);
    }

    public void setContentMediaType(String newValue) {
        this.setProperty("contentMediaType", newValue);
    }

    public Schema getContentSchema() {
        return (Schema)this.getProperty("contentSchema", Schema.class);
    }

    public void setContentSchema(Schema newValue) {
        this.setProperty("contentSchema", newValue);
    }

    public Object getDefaultValue() {
        return this.getProperty("default", Object.class);
    }

    public void setDefaultValue(Object newValue) {
        this.setProperty("default", newValue);
    }

    public Map<String, List<String>> getDependentRequired() {
        return this.getMapProperty("dependentRequired");
    }

    public void setDependentRequired(Map<String, List<String>> newValue) {
        this.setMapProperty("dependentRequired", newValue);
    }

    public AbstractSchema addDependentRequired(String newKey, List<String> newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("dependentRequired", newKey, newValue);
        return this;
    }

    public void removeDependentRequired(String key) {
        this.removeMapPropertyEntry("dependentRequired", key);
    }

    public Map<String, Schema> getDependentSchemas() {
        return this.getMapProperty("dependentSchemas");
    }

    public void setDependentSchemas(Map<String, Schema> newValue) {
        this.setMapProperty("dependentSchemas", newValue);
    }

    public AbstractSchema addDependentSchema(String newKey, Schema newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("dependentSchemas", newKey, newValue);
        return this;
    }

    public void removeDependentSchema(String key) {
        this.removeMapPropertyEntry("dependentSchemas", key);
    }

    public Boolean getDeprecated() {
        return (Boolean)this.getProperty("deprecated", Boolean.class);
    }

    public void setDeprecated(Boolean newValue) {
        this.setProperty("deprecated", newValue);
    }

    public Discriminator getDiscriminator() {
        return (Discriminator)this.getProperty("discriminator", Discriminator.class);
    }

    public void setDiscriminator(Discriminator newValue) {
        this.setProperty("discriminator", newValue);
    }

    public Schema getElseSchema() {
        return (Schema)this.getProperty("else", Schema.class);
    }

    public void setElseSchema(Schema newValue) {
        this.setProperty("else", newValue);
    }

    public List<Object> getEnumeration() {
        return this.getListProperty("enum");
    }

    public void setEnumeration(List<Object> newValue) {
        this.setListProperty("enum", newValue);
    }

    public AbstractSchema addEnumeration(Object newValue) {
        this.addListPropertyEntry("enum", newValue);
        return this;
    }

    public void removeEnumeration(Object value) {
        this.removeListPropertyEntry("enum", value);
    }

    public Object getExample() {
        return this.getProperty("example", Object.class);
    }

    public void setExample(Object newValue) {
        this.setProperty("example", newValue);
    }

    public List<Object> getExamples() {
        return this.getListProperty("examples");
    }

    public void setExamples(List<Object> newValue) {
        this.setListProperty("examples", newValue);
    }

    public AbstractSchema addExample(Object newValue) {
        this.addListPropertyEntry("examples", newValue);
        return this;
    }

    public void removeExample(Object value) {
        this.removeListPropertyEntry("examples", value);
    }

    public BigDecimal getExclusiveMaximum() {
        return (BigDecimal)this.getProperty("exclusiveMaximum", BigDecimal.class);
    }

    public void setExclusiveMaximum(BigDecimal newValue) {
        this.setProperty("exclusiveMaximum", newValue);
    }

    public BigDecimal getExclusiveMinimum() {
        return (BigDecimal)this.getProperty("exclusiveMinimum", BigDecimal.class);
    }

    public void setExclusiveMinimum(BigDecimal newValue) {
        this.setProperty("exclusiveMinimum", newValue);
    }

    public String getFormat() {
        return (String)this.getProperty("format", String.class);
    }

    public void setFormat(String newValue) {
        this.setProperty("format", newValue);
    }

    public Schema getIfSchema() {
        return (Schema)this.getProperty("if", Schema.class);
    }

    public void setIfSchema(Schema newValue) {
        this.setProperty("if", newValue);
    }

    public Schema getItems() {
        return (Schema)this.getProperty("items", Schema.class);
    }

    public void setItems(Schema newValue) {
        this.setProperty("items", newValue);
    }

    public Integer getMaxContains() {
        return (Integer)this.getProperty("maxContains", Integer.class);
    }

    public void setMaxContains(Integer newValue) {
        this.setProperty("maxContains", newValue);
    }

    public BigDecimal getMaximum() {
        return (BigDecimal)this.getProperty("maximum", BigDecimal.class);
    }

    public void setMaximum(BigDecimal newValue) {
        this.setProperty("maximum", newValue);
    }

    public Integer getMaxItems() {
        return (Integer)this.getProperty("maxItems", Integer.class);
    }

    public void setMaxItems(Integer newValue) {
        this.setProperty("maxItems", newValue);
    }

    public Integer getMaxLength() {
        return (Integer)this.getProperty("maxLength", Integer.class);
    }

    public void setMaxLength(Integer newValue) {
        this.setProperty("maxLength", newValue);
    }

    public Integer getMaxProperties() {
        return (Integer)this.getProperty("maxProperties", Integer.class);
    }

    public void setMaxProperties(Integer newValue) {
        this.setProperty("maxProperties", newValue);
    }

    public Integer getMinContains() {
        return (Integer)this.getProperty("minContains", Integer.class);
    }

    public void setMinContains(Integer newValue) {
        this.setProperty("minContains", newValue);
    }

    public BigDecimal getMinimum() {
        return (BigDecimal)this.getProperty("minimum", BigDecimal.class);
    }

    public void setMinimum(BigDecimal newValue) {
        this.setProperty("minimum", newValue);
    }

    public Integer getMinItems() {
        return (Integer)this.getProperty("minItems", Integer.class);
    }

    public void setMinItems(Integer newValue) {
        this.setProperty("minItems", newValue);
    }

    public Integer getMinLength() {
        return (Integer)this.getProperty("minLength", Integer.class);
    }

    public void setMinLength(Integer newValue) {
        this.setProperty("minLength", newValue);
    }

    public Integer getMinProperties() {
        return (Integer)this.getProperty("minProperties", Integer.class);
    }

    public void setMinProperties(Integer newValue) {
        this.setProperty("minProperties", newValue);
    }

    public BigDecimal getMultipleOf() {
        return (BigDecimal)this.getProperty("multipleOf", BigDecimal.class);
    }

    public void setMultipleOf(BigDecimal newValue) {
        this.setProperty("multipleOf", newValue);
    }

    public Schema getNot() {
        return (Schema)this.getProperty("not", Schema.class);
    }

    public void setNot(Schema newValue) {
        this.setProperty("not", newValue);
    }

    public List<Schema> getOneOf() {
        return this.getListProperty("oneOf");
    }

    public void setOneOf(List<Schema> newValue) {
        this.setListProperty("oneOf", newValue);
    }

    public AbstractSchema addOneOf(Schema newValue) {
        this.addListPropertyEntry("oneOf", newValue);
        return this;
    }

    public void removeOneOf(Schema value) {
        this.removeListPropertyEntry("oneOf", value);
    }

    public String getPattern() {
        return (String)this.getProperty("pattern", String.class);
    }

    public void setPattern(String newValue) {
        this.setProperty("pattern", newValue);
    }

    public Map<String, Schema> getPatternProperties() {
        return this.getMapProperty("patternProperties");
    }

    public void setPatternProperties(Map<String, Schema> newValue) {
        this.setMapProperty("patternProperties", newValue);
    }

    public AbstractSchema addPatternProperty(String newKey, Schema newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("patternProperties", newKey, newValue);
        return this;
    }

    public void removePatternProperty(String key) {
        this.removeMapPropertyEntry("patternProperties", key);
    }

    public List<Schema> getPrefixItems() {
        return this.getListProperty("prefixItems");
    }

    public void setPrefixItems(List<Schema> newValue) {
        this.setListProperty("prefixItems", newValue);
    }

    public AbstractSchema addPrefixItem(Schema newValue) {
        this.addListPropertyEntry("prefixItems", newValue);
        return this;
    }

    public void removePrefixItem(Schema value) {
        this.removeListPropertyEntry("prefixItems", value);
    }

    public Map<String, Schema> getProperties() {
        return this.getMapProperty("properties");
    }

    public void setProperties(Map<String, Schema> newValue) {
        this.setMapProperty("properties", newValue);
    }

    public AbstractSchema addProperty(String newKey, Schema newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("properties", newKey, newValue);
        return this;
    }

    public void removeProperty(String key) {
        this.removeMapPropertyEntry("properties", key);
    }

    public Schema getPropertyNames() {
        return (Schema)this.getProperty("propertyNames", Schema.class);
    }

    public void setPropertyNames(Schema newValue) {
        this.setProperty("propertyNames", newValue);
    }

    public Boolean getReadOnly() {
        return (Boolean)this.getProperty("readOnly", Boolean.class);
    }

    public void setReadOnly(Boolean newValue) {
        this.setProperty("readOnly", newValue);
    }

    public List<String> getRequired() {
        return this.getListProperty("required");
    }

    public void setRequired(List<String> newValue) {
        this.setListProperty("required", newValue);
    }

    public AbstractSchema addRequired(String newValue) {
        this.addListPropertyEntry("required", newValue);
        return this;
    }

    public void removeRequired(String value) {
        this.removeListPropertyEntry("required", value);
    }

    public String getSchemaDialect() {
        return (String)this.getProperty("$schema", String.class);
    }

    public void setSchemaDialect(String newValue) {
        this.setProperty("$schema", newValue);
    }

    public Schema getThenSchema() {
        return (Schema)this.getProperty("then", Schema.class);
    }

    public void setThenSchema(Schema newValue) {
        this.setProperty("then", newValue);
    }

    public String getTitle() {
        return (String)this.getProperty("title", String.class);
    }

    public void setTitle(String newValue) {
        this.setProperty("title", newValue);
    }

    public List<Schema.SchemaType> getType() {
        return this.getListProperty("type");
    }

    public void setType(List<Schema.SchemaType> newValue) {
        this.setListProperty("type", newValue);
    }

    public AbstractSchema addType(Schema.SchemaType newValue) {
        this.addListPropertyEntry("type", newValue);
        return this;
    }

    public void removeType(Schema.SchemaType value) {
        this.removeListPropertyEntry("type", value);
    }

    public Schema getUnevaluatedItems() {
        return (Schema)this.getProperty("unevaluatedItems", Schema.class);
    }

    public void setUnevaluatedItems(Schema newValue) {
        this.setProperty("unevaluatedItems", newValue);
    }

    public Schema getUnevaluatedProperties() {
        return (Schema)this.getProperty("unevaluatedProperties", Schema.class);
    }

    public void setUnevaluatedProperties(Schema newValue) {
        this.setProperty("unevaluatedProperties", newValue);
    }

    public Boolean getUniqueItems() {
        return (Boolean)this.getProperty("uniqueItems", Boolean.class);
    }

    public void setUniqueItems(Boolean newValue) {
        this.setProperty("uniqueItems", newValue);
    }

    public Boolean getWriteOnly() {
        return (Boolean)this.getProperty("writeOnly", Boolean.class);
    }

    public void setWriteOnly(Boolean newValue) {
        this.setProperty("writeOnly", newValue);
    }

    public XML getXml() {
        return (XML)this.getProperty("xml", XML.class);
    }

    public void setXml(XML newValue) {
        this.setProperty("xml", newValue);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(54);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(54);

        public Properties() {
            this.types.put("additionalProperties", DataType.type(Schema.class));
            this.minVersions.put("additionalProperties", OpenApiVersion.V3_0);
            this.types.put("allOf", DataType.listOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("allOf", OpenApiVersion.V3_0);
            this.types.put("anyOf", DataType.listOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("anyOf", OpenApiVersion.V3_0);
            this.types.put("$comment", DataType.type(String.class));
            this.minVersions.put("$comment", OpenApiVersion.V3_1);
            this.types.put("const", DataType.type(Object.class));
            this.minVersions.put("const", OpenApiVersion.V3_1);
            this.types.put("contains", DataType.type(Schema.class));
            this.minVersions.put("contains", OpenApiVersion.V3_1);
            this.types.put("contentEncoding", DataType.type(String.class));
            this.minVersions.put("contentEncoding", OpenApiVersion.V3_1);
            this.types.put("contentMediaType", DataType.type(String.class));
            this.minVersions.put("contentMediaType", OpenApiVersion.V3_1);
            this.types.put("contentSchema", DataType.type(Schema.class));
            this.minVersions.put("contentSchema", OpenApiVersion.V3_1);
            this.types.put("default", DataType.type(Object.class));
            this.minVersions.put("default", OpenApiVersion.V3_0);
            this.types.put("dependentRequired", DataType.mapOf((DataType)DataType.listOf((DataType)DataType.type(String.class))));
            this.minVersions.put("dependentRequired", OpenApiVersion.V3_1);
            this.types.put("dependentSchemas", DataType.mapOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("dependentSchemas", OpenApiVersion.V3_1);
            this.types.put("deprecated", DataType.type(Boolean.class));
            this.minVersions.put("deprecated", OpenApiVersion.V3_0);
            this.types.put("description", DataType.type(String.class));
            this.minVersions.put("description", OpenApiVersion.V3_0);
            this.types.put("discriminator", DataType.type(Discriminator.class));
            this.minVersions.put("discriminator", OpenApiVersion.V3_0);
            this.types.put("else", DataType.type(Schema.class));
            this.minVersions.put("else", OpenApiVersion.V3_1);
            this.types.put("enum", DataType.listOf((DataType)DataType.type(Object.class)));
            this.minVersions.put("enum", OpenApiVersion.V3_0);
            this.types.put("example", DataType.type(Object.class));
            this.minVersions.put("example", OpenApiVersion.V3_0);
            this.types.put("examples", DataType.listOf((DataType)DataType.type(Object.class)));
            this.minVersions.put("examples", OpenApiVersion.V3_1);
            this.types.put("exclusiveMaximum", DataType.type(BigDecimal.class));
            this.minVersions.put("exclusiveMaximum", OpenApiVersion.V3_0);
            this.types.put("exclusiveMinimum", DataType.type(BigDecimal.class));
            this.minVersions.put("exclusiveMinimum", OpenApiVersion.V3_0);
            this.types.put("externalDocs", DataType.type(ExternalDocumentation.class));
            this.minVersions.put("externalDocs", OpenApiVersion.V3_0);
            this.types.put("format", DataType.type(String.class));
            this.minVersions.put("format", OpenApiVersion.V3_0);
            this.types.put("if", DataType.type(Schema.class));
            this.minVersions.put("if", OpenApiVersion.V3_1);
            this.types.put("items", DataType.type(Schema.class));
            this.minVersions.put("items", OpenApiVersion.V3_0);
            this.types.put("maxContains", DataType.type(Integer.class));
            this.minVersions.put("maxContains", OpenApiVersion.V3_1);
            this.types.put("maximum", DataType.type(BigDecimal.class));
            this.minVersions.put("maximum", OpenApiVersion.V3_0);
            this.types.put("maxItems", DataType.type(Integer.class));
            this.minVersions.put("maxItems", OpenApiVersion.V3_0);
            this.types.put("maxLength", DataType.type(Integer.class));
            this.minVersions.put("maxLength", OpenApiVersion.V3_0);
            this.types.put("maxProperties", DataType.type(Integer.class));
            this.minVersions.put("maxProperties", OpenApiVersion.V3_0);
            this.types.put("minContains", DataType.type(Integer.class));
            this.minVersions.put("minContains", OpenApiVersion.V3_1);
            this.types.put("minimum", DataType.type(BigDecimal.class));
            this.minVersions.put("minimum", OpenApiVersion.V3_0);
            this.types.put("minItems", DataType.type(Integer.class));
            this.minVersions.put("minItems", OpenApiVersion.V3_0);
            this.types.put("minLength", DataType.type(Integer.class));
            this.minVersions.put("minLength", OpenApiVersion.V3_0);
            this.types.put("minProperties", DataType.type(Integer.class));
            this.minVersions.put("minProperties", OpenApiVersion.V3_0);
            this.types.put("multipleOf", DataType.type(BigDecimal.class));
            this.minVersions.put("multipleOf", OpenApiVersion.V3_0);
            this.types.put("not", DataType.type(Schema.class));
            this.minVersions.put("not", OpenApiVersion.V3_0);
            this.types.put("oneOf", DataType.listOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("oneOf", OpenApiVersion.V3_0);
            this.types.put("pattern", DataType.type(String.class));
            this.minVersions.put("pattern", OpenApiVersion.V3_0);
            this.types.put("patternProperties", DataType.mapOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("patternProperties", OpenApiVersion.V3_1);
            this.types.put("prefixItems", DataType.listOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("prefixItems", OpenApiVersion.V3_1);
            this.types.put("properties", DataType.mapOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("properties", OpenApiVersion.V3_0);
            this.types.put("propertyNames", DataType.type(Schema.class));
            this.minVersions.put("propertyNames", OpenApiVersion.V3_1);
            this.types.put("readOnly", DataType.type(Boolean.class));
            this.minVersions.put("readOnly", OpenApiVersion.V3_0);
            this.types.put("required", DataType.listOf((DataType)DataType.type(String.class)));
            this.minVersions.put("required", OpenApiVersion.V3_0);
            this.types.put("$schema", DataType.type(String.class));
            this.minVersions.put("$schema", OpenApiVersion.V3_1);
            this.types.put("then", DataType.type(Schema.class));
            this.minVersions.put("then", OpenApiVersion.V3_1);
            this.types.put("title", DataType.type(String.class));
            this.minVersions.put("title", OpenApiVersion.V3_0);
            this.types.put("type", DataType.listOf((DataType)DataType.type(Schema.SchemaType.class)));
            this.minVersions.put("type", OpenApiVersion.V3_0);
            this.types.put("unevaluatedItems", DataType.type(Schema.class));
            this.minVersions.put("unevaluatedItems", OpenApiVersion.V3_1);
            this.types.put("unevaluatedProperties", DataType.type(Schema.class));
            this.minVersions.put("unevaluatedProperties", OpenApiVersion.V3_1);
            this.types.put("uniqueItems", DataType.type(Boolean.class));
            this.minVersions.put("uniqueItems", OpenApiVersion.V3_0);
            this.types.put("writeOnly", DataType.type(Boolean.class));
            this.minVersions.put("writeOnly", OpenApiVersion.V3_0);
            this.types.put("xml", DataType.type(XML.class));
            this.minVersions.put("xml", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

