/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public class TranscoderMarshallerAdapter
extends OneToManyTranscoder {
    protected static final Log logger = LogFactory.getLog(TranscoderMarshallerAdapter.class, Log.class);
    private final Marshaller marshaller;

    public TranscoderMarshallerAdapter(Marshaller marshaller) {
        super(marshaller.mediaType(), MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_UNKNOWN);
        this.marshaller = marshaller;
    }

    @Override
    public Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.equals(MediaType.APPLICATION_UNKNOWN) || contentType.equals(MediaType.APPLICATION_UNKNOWN)) {
                return content;
            }
            if (destinationType.match(this.marshaller.mediaType())) {
                return contentType.equals(this.marshaller.mediaType()) ? content : (Object)this.marshaller.objectToByteBuffer(content);
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return this.marshaller.objectFromByteBuffer((byte[])content);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            throw new CacheException(e);
        }
        throw Log.CONTAINER.unsupportedConversion(Util.toStr(content), contentType, destinationType);
    }
}

