/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.security;

import io.quarkus.vertx.http.runtime.FormAuthConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.SmallRyeConfig;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

@Experimental(value="This API is currently experimental and might get changed")
public interface Form {
    public static Builder builder() {
        return new Builder();
    }

    public static HttpAuthenticationMechanism create() {
        return Form.builder().build();
    }

    public static final class Builder {
        private String postLocation;
        private Optional<String> loginPage;
        private String usernameParameter;
        private String passwordParameter;
        private Optional<String> errorPage;
        private Optional<String> landingPage;
        private boolean redirectAfterLogin;
        private String locationCookie;
        private Duration timeout;
        private Duration newCookieInterval;
        private String cookieName;
        private Optional<String> cookiePath;
        private Optional<String> cookieDomain;
        private boolean httpOnlyCookie;
        private FormAuthConfig.CookieSameSite cookieSameSite;
        private Optional<Duration> cookieMaxAge;
        private Optional<String> encryptionKey;

        public Builder() {
            this((VertxHttpConfig)((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getConfigMapping(VertxHttpConfig.class));
        }

        private Builder(VertxHttpConfig vertxHttpConfig) {
            FormAuthConfig formAuthConfig = vertxHttpConfig.auth().form();
            this.postLocation = formAuthConfig.postLocation();
            this.loginPage = formAuthConfig.loginPage();
            this.usernameParameter = formAuthConfig.usernameParameter();
            this.passwordParameter = formAuthConfig.passwordParameter();
            this.errorPage = formAuthConfig.errorPage();
            this.landingPage = formAuthConfig.landingPage();
            this.redirectAfterLogin = formAuthConfig.redirectAfterLogin();
            this.locationCookie = formAuthConfig.locationCookie();
            this.timeout = formAuthConfig.timeout();
            this.newCookieInterval = formAuthConfig.newCookieInterval();
            this.cookieName = formAuthConfig.cookieName();
            this.cookiePath = formAuthConfig.cookiePath();
            this.cookieDomain = formAuthConfig.cookieDomain();
            this.httpOnlyCookie = formAuthConfig.httpOnlyCookie();
            this.cookieSameSite = formAuthConfig.cookieSameSite();
            this.cookieMaxAge = formAuthConfig.cookieMaxAge();
            this.encryptionKey = vertxHttpConfig.encryptionKey();
        }

        public Builder postLocation(String postLocation) {
            Objects.requireNonNull(postLocation);
            this.postLocation = postLocation;
            return this;
        }

        public Builder loginPage(String loginPage) {
            this.loginPage = Optional.ofNullable(loginPage);
            return this;
        }

        public Builder usernameParameter(String usernameParameter) {
            Objects.requireNonNull(usernameParameter);
            this.usernameParameter = usernameParameter;
            return this;
        }

        public Builder passwordParameter(String passwordParameter) {
            Objects.requireNonNull(passwordParameter);
            this.passwordParameter = passwordParameter;
            return this;
        }

        public Builder errorPage(String errorPage) {
            this.errorPage = Optional.ofNullable(errorPage);
            return this;
        }

        public Builder landingPage(String landingPage) {
            this.landingPage = Optional.ofNullable(landingPage);
            return this;
        }

        public Builder locationCookie(String locationCookie) {
            Objects.requireNonNull(locationCookie);
            this.locationCookie = locationCookie;
            return this;
        }

        public Builder timeout(Duration timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout;
            return this;
        }

        public Builder newCookieInterval(Duration newCookieInterval) {
            Objects.requireNonNull(newCookieInterval);
            this.newCookieInterval = newCookieInterval;
            return this;
        }

        public Builder cookieName(String cookieName) {
            Objects.requireNonNull(cookieName);
            this.cookieName = cookieName;
            return this;
        }

        public Builder cookiePath(String cookiePath) {
            this.cookiePath = Optional.ofNullable(cookiePath);
            return this;
        }

        public Builder cookieDomain(String cookieDomain) {
            this.cookieDomain = Optional.ofNullable(cookieDomain);
            return this;
        }

        public Builder httpOnlyCookie(boolean httpOnlyCookie) {
            this.httpOnlyCookie = httpOnlyCookie;
            return this;
        }

        public Builder httpOnlyCookie() {
            return this.httpOnlyCookie(true);
        }

        public Builder cookieSameSite(FormAuthConfig.CookieSameSite cookieSameSite) {
            Objects.requireNonNull(cookieSameSite);
            this.cookieSameSite = cookieSameSite;
            return this;
        }

        public Builder cookieMaxAge(Duration cookieMaxAge) {
            this.cookieMaxAge = Optional.ofNullable(cookieMaxAge);
            return this;
        }

        public Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = Optional.ofNullable(encryptionKey);
            return this;
        }

        public HttpAuthenticationMechanism build() {
            return new FormAuthenticationMechanism(this.createFormConfig(), this.encryptionKey);
        }

        private FormAuthConfig createFormConfig() {
            record FormConfigImpl(Optional<String> loginPage, String usernameParameter, String passwordParameter, Optional<String> errorPage, Optional<String> landingPage, boolean redirectAfterLogin, String locationCookie, Duration timeout, Duration newCookieInterval, String cookieName, Optional<String> cookiePath, Optional<String> cookieDomain, boolean httpOnlyCookie, FormAuthConfig.CookieSameSite cookieSameSite, Optional<Duration> cookieMaxAge, String postLocation) implements FormAuthConfig
            {
            }
            return new FormConfigImpl(this.loginPage, this.usernameParameter, this.passwordParameter, this.errorPage, this.landingPage, this.redirectAfterLogin, this.locationCookie, this.timeout, this.newCookieInterval, this.cookieName, this.cookiePath, this.cookieDomain, this.httpOnlyCookie, this.cookieSameSite, this.cookieMaxAge, this.postLocation);
        }
    }
}

