/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Formattable;
import java.util.Locale;
import java.util.UUID;
import org.jboss.logmanager.formatters.ColorUtil;
import org.jboss.logmanager.formatters.GeneralFlags;
import org.jboss.logmanager.formatters.NumericFlags;
import org.jboss.logmanager.formatters.Printf;
import org.jboss.logmanager.handlers.ConsoleHandler;

class ColorPrintf
extends Printf {
    private final int darken;
    private final boolean trueColor = ConsoleHandler.isTrueColor();

    ColorPrintf(int darken) {
        super(Locale.getDefault());
        this.darken = darken;
    }

    @Override
    public StringBuilder formatDirect(StringBuilder destination, String format, Object ... params) {
        ColorUtil.endFgColor(destination);
        super.formatDirect(destination, format, params);
        return destination;
    }

    @Override
    protected void formatTimeTextField(StringBuilder target, TemporalAccessor ta, TemporalField field, String[] symbols, GeneralFlags genFlags, int width) {
        super.formatTimeTextField(target, ta, field, symbols, genFlags, width);
    }

    @Override
    protected void formatTimeZoneId(StringBuilder target, TemporalAccessor ta, GeneralFlags genFlags, int width) {
        super.formatTimeZoneId(target, ta, genFlags, width);
    }

    @Override
    protected void formatTimeZoneOffset(StringBuilder target, TemporalAccessor ta, GeneralFlags genFlags, int width) {
        super.formatTimeZoneOffset(target, ta, genFlags, width);
    }

    @Override
    protected void formatTimeField(StringBuilder target, TemporalAccessor ta, TemporalField field, GeneralFlags genFlags, int width, int zeroPad) {
        super.formatTimeField(target, ta, field, genFlags, width, zeroPad);
    }

    @Override
    protected void formatPercent(StringBuilder target) {
        super.formatPercent(target);
    }

    @Override
    protected void formatLineSeparator(StringBuilder target) {
        super.formatLineSeparator(target);
    }

    @Override
    protected void formatFormattableString(StringBuilder target, Formattable formattable, GeneralFlags genFlags, int width, int precision) {
        super.formatFormattableString(target, formattable, genFlags, width, precision);
    }

    @Override
    protected void formatPlainString(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        if (item instanceof Class || item instanceof Executable || item instanceof Field) {
            ColorUtil.startFgColor(target, this.trueColor, 255 >>> this.darken, 255 >>> this.darken, 221 >>> this.darken);
        } else if (item instanceof UUID) {
            ColorUtil.startFgColor(target, this.trueColor, 221 >>> this.darken, 255 >>> this.darken, 221 >>> this.darken);
        } else {
            ColorUtil.startFgColor(target, this.trueColor, 221 >>> this.darken, 221 >>> this.darken, 221 >>> this.darken);
        }
        super.formatPlainString(target, item, genFlags, width, precision);
        ColorUtil.endFgColor(target);
    }

    @Override
    protected void formatBoolean(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        super.formatBoolean(target, item, genFlags, width, precision);
    }

    @Override
    protected void formatHashCode(StringBuilder target, Object item, GeneralFlags genFlags, int width, int precision) {
        super.formatHashCode(target, item, genFlags, width, precision);
    }

    @Override
    protected void formatCharacter(StringBuilder target, int codePoint, GeneralFlags genFlags, int width, int precision) {
        super.formatCharacter(target, codePoint, genFlags, width, precision);
    }

    @Override
    protected void formatDecimalInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        super.formatDecimalInteger(target, item, genFlags, numFlags, width);
    }

    @Override
    protected void formatOctalInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        super.formatOctalInteger(target, item, genFlags, numFlags, width);
    }

    @Override
    protected void formatHexInteger(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width) {
        super.formatHexInteger(target, item, genFlags, numFlags, width);
    }

    @Override
    protected void formatFloatingPointSci(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        super.formatFloatingPointSci(target, item, genFlags, numFlags, width, precision);
    }

    @Override
    protected void formatFloatingPointDecimal(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        super.formatFloatingPointDecimal(target, item, genFlags, numFlags, width, precision);
    }

    @Override
    protected void formatFloatingPointGeneral(StringBuilder target, Number item, GeneralFlags genFlags, NumericFlags numFlags, int width, int precision) {
        super.formatFloatingPointGeneral(target, item, genFlags, numFlags, width, precision);
    }
}

