/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.keycloak.crypto.HashException;
import org.keycloak.models.jpa.entities.UserEntity;

public class JpaHashUtils {
    private static byte[] hash(byte[] inputBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(inputBytes);
            return md.digest();
        }
        catch (Exception e) {
            throw new HashException("Error when creating token hash", (Throwable)e);
        }
    }

    public static byte[] hashForAttributeValue(String value) {
        return JpaHashUtils.hash(value.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] hashForAttributeValueLowerCase(String value) {
        return JpaHashUtils.hash(value.toLowerCase(Locale.ENGLISH).getBytes(StandardCharsets.UTF_8));
    }

    public static boolean compareSourceValueLowerCase(String value1, String value2) {
        return Objects.equals(value1.toLowerCase(Locale.ENGLISH), value2.toLowerCase(Locale.ENGLISH));
    }

    public static boolean compareSourceValue(String value1, String value2) {
        return Objects.equals(value1, value2);
    }

    public static Predicate<UserEntity> predicateForFilteringUsersByAttributes(Map<String, String> customLongValueSearchAttributes, BiPredicate<String, String> valueComparator) {
        return userEntity -> customLongValueSearchAttributes.isEmpty() || customLongValueSearchAttributes.entrySet().stream().allMatch(longAttrEntry -> userEntity.getAttributes().stream().anyMatch(userAttribute -> Objects.equals(((String)longAttrEntry.getKey()).toLowerCase(), userAttribute.getName().toLowerCase()) && valueComparator.test((String)longAttrEntry.getValue(), userAttribute.getValue())));
    }
}

