/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.LDAPConfigDecorator;

public class LDAPIdentityStoreRegistry {
    private static final Logger logger = Logger.getLogger(LDAPIdentityStoreRegistry.class);
    private final Map<String, LDAPConfig> ldapStores = new ConcurrentHashMap<String, LDAPConfig>();

    public LDAPIdentityStore getLdapStore(KeycloakSession session, ComponentModel ldapModel, Map<ComponentModel, LDAPConfigDecorator> configDecorators) {
        MultivaluedHashMap configModel = ldapModel.getConfig();
        LDAPConfig ldapConfig = new LDAPConfig((MultivaluedHashMap<String, String>)configModel);
        for (Map.Entry<ComponentModel, LDAPConfigDecorator> entry : configDecorators.entrySet()) {
            ComponentModel mapperModel = entry.getKey();
            LDAPConfigDecorator decorator = entry.getValue();
            decorator.updateLDAPConfig(ldapConfig, mapperModel);
        }
        LDAPConfig cachedConfig = this.ldapStores.get(ldapModel.getId());
        if (cachedConfig == null || !ldapConfig.equals(cachedConfig)) {
            this.logLDAPConfig(session, ldapModel, ldapConfig);
            this.ldapStores.put(ldapModel.getId(), ldapConfig);
        }
        return new LDAPIdentityStore(session, ldapConfig);
    }

    private void logLDAPConfig(KeycloakSession session, ComponentModel ldapModel, LDAPConfig ldapConfig) {
        logger.infof("Creating new LDAP Store for the LDAP storage provider: '%s', LDAP Configuration: %s", (Object)ldapModel.getName(), (Object)ldapConfig.toString());
        if (logger.isDebugEnabled()) {
            RealmModel realm = session.realms().getRealm(ldapModel.getParentId());
            realm.getComponentsStream(ldapModel.getId()).forEach(c -> logger.debugf("Mapper for provider: %s, Mapper name: %s, Provider: %s, Mapper configuration: %s", new Object[]{ldapModel.getName(), c.getName(), c.getProviderId(), c.getConfig().toString()}));
        }
    }
}

