/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;
import org.wildfly.security.ssl.SecurityLevel;

final class LevelCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<SecurityLevel> set;

    LevelCipherSuitePredicate(EnumSet<SecurityLevel> set) {
        this.set = set;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("openssl security level is one of (");
        Iterator iterator = this.set.iterator();
        if (iterator.hasNext()) {
            SecurityLevel securityLevel = (SecurityLevel)((Object)iterator.next());
            b.append((Object)securityLevel);
            while (iterator.hasNext()) {
                securityLevel = (SecurityLevel)((Object)iterator.next());
                b.append(", ");
                b.append((Object)securityLevel);
            }
        }
        b.append(')');
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getLevel());
    }

    @Override
    boolean isAlwaysTrue() {
        return SecurityLevel.isFull(this.set);
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

