/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.session;

import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class JTAStatelessSessionOpener {
    private final SessionFactory sessionFactory;
    private final StatelessSessionBuilder cachedOptions;

    public static JTAStatelessSessionOpener create(SessionFactory sessionFactory) {
        CurrentTenantIdentifierResolver currentTenantIdentifierResolver = ((SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class)).getCurrentTenantIdentifierResolver();
        if (currentTenantIdentifierResolver == null) {
            return new JTAStatelessSessionOpener(sessionFactory, JTAStatelessSessionOpener.createOptions(sessionFactory));
        }
        return new JTAStatelessSessionOpener(sessionFactory, null);
    }

    private static StatelessSessionBuilder createOptions(SessionFactory sessionFactory) {
        return sessionFactory.withStatelessOptions();
    }

    public JTAStatelessSessionOpener(SessionFactory sessionFactory, StatelessSessionBuilder cachedOptions) {
        this.sessionFactory = sessionFactory;
        this.cachedOptions = cachedOptions;
    }

    public StatelessSession openSession() {
        StatelessSessionBuilder options = this.cachedOptions != null ? this.cachedOptions : JTAStatelessSessionOpener.createOptions(this.sessionFactory);
        return options.openStatelessSession();
    }
}

