/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.broker.oidc.mappers.AbstractClaimToRoleMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.provider.ProviderConfigProperty;

public class ClaimToRoleMapper
extends AbstractClaimToRoleMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    public static final String PROVIDER_ID = "oidc-role-idp-mapper";

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Role Importer";
    }

    public String getDisplayType() {
        return "Claim to Role";
    }

    @Override
    protected boolean applies(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        return super.hasClaimValue(mapperModel, context);
    }

    public String getHelpText() {
        return "If a claim exists, grant the user the specified realm or client role.";
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName("claim");
        property1.setLabel("Claim");
        property1.setHelpText("Name of claim to search for in token. You can reference nested claims using a '.', i.e. 'address.locality'. To use dot (.) literally, escape it with backslash (\\.)");
        property1.setType("String");
        configProperties.add(property1);
        property1 = new ProviderConfigProperty();
        property1.setName("claim.value");
        property1.setLabel("Claim Value");
        property1.setHelpText("Value the claim must have.  If the claim is an array, then the value must be contained in the array.");
        property1.setType("String");
        configProperties.add(property1);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("role");
        property.setLabel("Role");
        property.setHelpText("Role to grant to user if claim is present.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference a client role the syntax is clientname.clientrole, i.e. myclient.myrole");
        property.setType("Role");
        configProperties.add(property);
    }
}

