/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenIntrospectionEndpoint;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.util.DPoPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TokenEndpoint {
    private static final Logger logger = Logger.getLogger(TokenEndpoint.class);
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private Map<String, String> clientAuthAttributes;
    private OIDCAdvancedConfigWrapper clientConfig;
    private final KeycloakSession session;
    private final HttpRequest request;
    private final HttpResponse httpResponse;
    private final HttpHeaders headers;
    private final ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private String grantType;
    private OAuth2GrantType grant;
    private Cors cors;

    public TokenEndpoint(KeycloakSession session, TokenManager tokenManager, EventBuilder event) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.tokenManager = tokenManager;
        this.realm = session.getContext().getRealm();
        this.event = event;
        this.request = session.getContext().getHttpRequest();
        this.httpResponse = session.getContext().getHttpResponse();
        this.headers = session.getContext().getRequestHeaders();
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response processGrantRequest() {
        this.cors = Cors.builder().auth().allowedMethods(new String[]{"POST"}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
        MultivaluedMap formParameters = this.request.getDecodedFormParameters();
        if (formParameters == null) {
            formParameters = new MultivaluedHashMap();
        }
        this.formParams = formParameters;
        this.grantType = (String)this.formParams.getFirst((Object)"grant_type");
        this.httpResponse.setHeader("Cache-Control", "no-store");
        this.httpResponse.setHeader("Pragma", "no-cache");
        this.checkSsl();
        this.checkRealm();
        this.checkGrantType();
        if (!this.grantType.equals("urn:ietf:params:oauth:grant-type:uma-ticket") && !this.grantType.equals("urn:ietf:params:oauth:grant-type:pre-authorized_code")) {
            this.checkClient();
            this.checkParameterDuplicated();
        }
        DPoPUtil.handleDPoPHeader(this.session, this.event, this.cors, this.clientConfig);
        OAuth2GrantType.Context context = new OAuth2GrantType.Context(this.session, (Object)this.clientConfig, this.clientAuthAttributes, this.formParams, this.event, this.cors, (Object)this.tokenManager);
        return this.grant.process(context);
    }

    @Path(value="introspect")
    public Object introspect() {
        return new TokenIntrospectionEndpoint(this.session, this.event);
    }

    @OPTIONS
    public Response preflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("CORS preflight from: {0}", this.headers.getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.builder().auth().preflight().allowedMethods(new String[]{"POST", "OPTIONS"}).add(Response.ok());
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors);
        this.client = clientAuth.getClient();
        this.clientAuthAttributes = clientAuth.getClientAuthAttributes();
        this.clientConfig = OIDCAdvancedConfigWrapper.fromClientModel(this.client);
        this.cors.allowedOrigins(this.session, this.client);
        if (this.client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkGrantType() {
        if (this.grantType == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Missing form parameter: grant_type", Response.Status.BAD_REQUEST);
        }
        this.grant = (OAuth2GrantType)this.session.getProvider(OAuth2GrantType.class, this.grantType);
        if (this.grant == null) {
            throw this.newUnsupportedGrantTypeException();
        }
        this.event.event(this.grant.getEventType());
        this.event.detail("grant_type", this.grantType);
    }

    private CorsErrorResponseException newUnsupportedGrantTypeException() {
        return new CorsErrorResponseException(this.cors, "unsupported_grant_type", "Unsupported grant_type", Response.Status.BAD_REQUEST);
    }

    private void checkParameterDuplicated() {
        for (Map.Entry entry : this.formParams.entrySet()) {
            if (((List)entry.getValue()).size() == 1 || this.grant.getSupportedMultivaluedRequestParameters().contains(entry.getKey())) continue;
            throw new CorsErrorResponseException(this.cors, "invalid_request", "duplicated parameter", Response.Status.BAD_REQUEST);
        }
    }

    public static class TokenExchangeSamlProtocol
    extends SamlProtocol {
        final SamlClient samlClient;

        public TokenExchangeSamlProtocol(SamlClient samlClient) {
            this.samlClient = samlClient;
        }

        @Override
        protected Response buildAuthenticatedResponse(AuthenticatedClientSessionModel clientSession, String redirectUri, Document samlDocument, JaxrsSAML2BindingBuilder bindingBuilder) throws ConfigurationException, ProcessingException, IOException {
            JaxrsSAML2BindingBuilder.PostBindingBuilder builder = bindingBuilder.postBinding(samlDocument);
            Element assertionElement = this.samlClient.requiresEncryption() ? DocumentUtil.getElement((Document)builder.getDocument(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ENCRYPTED_ASSERTION.get())) : DocumentUtil.getElement((Document)builder.getDocument(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()));
            if (assertionElement == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String assertion = DocumentUtil.getNodeAsString((Node)assertionElement);
            return Response.ok((Object)assertion, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }

        @Override
        protected Response buildErrorResponse(boolean isPostBinding, String destination, JaxrsSAML2BindingBuilder binding, Document document) throws ConfigurationException, ProcessingException, IOException {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

