/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.HardcodedClaim;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.ClaimsRepresentation;
import org.keycloak.representations.IDToken;
import org.keycloak.util.JsonSerialization;

public class ClaimsParameterWithValueIdTokenMapper
extends AbstractOIDCProtocolMapper
implements OIDCIDTokenMapper {
    private static final Logger LOGGER = Logger.getLogger(ClaimsParameterWithValueIdTokenMapper.class);
    public static final String PROVIDER_ID = "oidc-claims-param-value-idtoken-mapper";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String CLAIM_NAME = "claim.name";

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getDisplayType() {
        return "Claims parameter with value ID Token";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Claims specified by Claims parameter with value are put into an ID token.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        String claims = clientSessionCtx.getClientSession().getNote("claims");
        if (claims == null) {
            return;
        }
        if ("ID".equals(token.getType())) {
            this.putClaims(ClaimsRepresentation.ClaimContext.ID_TOKEN, claims, token, mappingModel, userSession);
        }
    }

    private void putClaims(ClaimsRepresentation.ClaimContext tokenType, String claims, IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        String claimName = (String)mappingModel.getConfig().get(CLAIM_NAME);
        if (claimName == null) {
            return;
        }
        ClaimsRepresentation claimsRep = null;
        try {
            claimsRep = (ClaimsRepresentation)JsonSerialization.readValue((String)claims, ClaimsRepresentation.class);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Invalid claims parameter", (Throwable)e);
            return;
        }
        if (!claimsRep.isPresent(claimName, tokenType) || claimsRep.isPresentAsNullClaim(claimName, tokenType)) {
            return;
        }
        ClaimsRepresentation.ClaimValue claimValue = claimsRep.getClaimValue(claimName, tokenType, String.class);
        if (!claimValue.isEssential()) {
            return;
        }
        String claim = (String)claimValue.getValue();
        if (claim == null) {
            return;
        }
        HardcodedClaim hardcodedClaimMapper = new HardcodedClaim();
        hardcodedClaimMapper.setClaim(token, HardcodedClaim.create("hard", claimName, claim, "String", false, true, false), userSession);
    }

    public static ProtocolMapperModel createMapper(String name, String attributeValue, boolean idToken) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(CLAIM_NAME, attributeValue);
        if (idToken) {
            config.put("id.token.claim", "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(CLAIM_NAME);
        property.setLabel("Claim name");
        property.setType("String");
        property.setHelpText("Name of the claim you want to set its value. 'true' and 'false can be used for boolean values.");
        configProperties.add(property);
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, ClaimsParameterWithValueIdTokenMapper.class);
    }
}

