/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticationFlowSelectorExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private Configuration configuration;

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "pkce-enforcer";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        if (context.getEvent() == ClientPolicyEvent.AUTHORIZATION_REQUEST) {
            AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
            this.executeOnAuthorizationRequest(authorizationRequestContext.getAuthenticationSession());
        }
    }

    private void executeOnAuthorizationRequest(AuthenticationSessionModel authSession) {
        if (this.configuration.getAuthFlowAlias() != null) {
            authSession.setAuthNote("requested-authentication-flow", this.configuration.getAuthFlowAlias());
            if (this.configuration.getAuthFlowLoa() != null) {
                authSession.setAuthNote("authentication-flow-level-of-authentication", String.valueOf(this.configuration.getAuthFlowLoa()));
            }
        }
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auth-flow-alias")
        protected String authFlowAlias;
        @JsonProperty(value="auth-flow-loa")
        protected Integer authFlowLoa;

        public String getAuthFlowAlias() {
            return this.authFlowAlias;
        }

        public void setAuthFlowAlias(String authFlowAlias) {
            this.authFlowAlias = authFlowAlias;
        }

        public Integer getAuthFlowLoa() {
            return this.authFlowLoa;
        }

        public void setAuthFlowLoa(Integer authFlowLoa) {
            this.authFlowLoa = authFlowLoa;
        }
    }
}

