/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.client;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.client.clienttype.ClientTypeException;

interface TypedClientAttribute {
    public static final Logger logger = Logger.getLogger(TypedClientAttribute.class);

    default public <T> T getClientAttribute(ClientType clientType, Supplier<T> clientGetter, Class<T> tClass) {
        String propertyName = this.getPropertyName();
        Object nonApplicableValue = this.getNonApplicableValue();
        if (!clientType.isApplicable(propertyName)) {
            try {
                return tClass.cast(nonApplicableValue);
            }
            catch (ClassCastException e) {
                logger.error("Could not apply client type property %s: %s", (Object)propertyName, (Throwable)e);
                throw e;
            }
        }
        Object typeValue = clientType.getTypeValue(propertyName, tClass);
        return (T)(typeValue == null ? clientGetter.get() : typeValue);
    }

    default public <T> void setClientAttribute(ClientType clientType, T newValue, Consumer<T> clientSetter, Class<T> tClass) {
        String propertyName = this.getPropertyName();
        if (!clientType.isApplicable(propertyName)) {
            if (!Objects.equals(this.getNonApplicableValue(), newValue)) {
                logger.warnf("Property %s is not-applicable to client type %s and can not be modified.", (Object)propertyName, (Object)clientType.getName());
            }
            return;
        }
        Object readOnlyValue = clientType.getTypeValue(propertyName, tClass);
        if (readOnlyValue != null && !readOnlyValue.equals(newValue)) {
            throw ClientTypeException.Message.CLIENT_UPDATE_FAILED_CLIENT_TYPE_VALIDATION.exception(new Object[]{propertyName});
        }
        clientSetter.accept(newValue);
    }

    public String getPropertyName();

    public Object getNonApplicableValue();
}

