/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.common.util.TriFunction;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.admin.ClientScopeEvaluateScopeMappingsResource;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientScopeEvaluateResource {
    protected static final Logger logger = Logger.getLogger(ClientScopeEvaluateResource.class);
    private final RealmModel realm;
    private final ClientModel client;
    private final AdminPermissionEvaluator auth;
    private final UriInfo uriInfo;
    private final KeycloakSession session;
    private final ClientConnection clientConnection;

    public ClientScopeEvaluateResource(KeycloakSession session, UriInfo uriInfo, RealmModel realm, AdminPermissionEvaluator auth, ClientModel client, ClientConnection clientConnection) {
        this.uriInfo = uriInfo;
        this.realm = realm;
        this.client = client;
        this.auth = auth;
        this.session = session;
        this.clientConnection = clientConnection;
    }

    @Path(value="scope-mappings/{roleContainerId}")
    public ClientScopeEvaluateScopeMappingsResource scopeMappings(@QueryParam(value="scope") String scopeParam, @Parameter(description="either realm name OR client UUID") @PathParam(value="roleContainerId") String roleContainerId) {
        RealmModel roleContainer;
        this.auth.clients().requireView(this.client);
        if (roleContainerId == null) {
            throw new NotFoundException("No roleContainerId provided");
        }
        Object object = roleContainer = roleContainerId.equals(this.realm.getName()) ? this.realm : this.realm.getClientById(roleContainerId);
        if (roleContainer == null) {
            throw new NotFoundException("Role Container not found");
        }
        return new ClientScopeEvaluateScopeMappingsResource(this.session, (RoleContainerModel)roleContainer, this.auth, this.client, scopeParam);
    }

    @GET
    @Path(value="protocol-mappers")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Return list of all protocol mappers, which will be used when generating tokens issued for particular client.", description="This means protocol mappers assigned to this client directly and protocol mappers assigned to all client scopes of this client.")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ProtocolMapperEvaluationRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<ProtocolMapperEvaluationRepresentation> getGrantedProtocolMappers(@QueryParam(value="scope") String scopeParam) {
        this.auth.clients().requireView(this.client);
        return TokenManager.getRequestedClientScopes(this.session, scopeParam, this.client, null).flatMap(mapperContainer -> mapperContainer.getProtocolMappersStream().filter(current -> ProtocolMapperUtils.isEnabled(this.session, current) && Objects.equals(current.getProtocol(), this.client.getProtocol())).map(current -> this.toProtocolMapperEvaluationRepresentation((ProtocolMapperModel)current, (ClientScopeModel)mapperContainer)));
    }

    private ProtocolMapperEvaluationRepresentation toProtocolMapperEvaluationRepresentation(ProtocolMapperModel mapper, ClientScopeModel mapperContainer) {
        ProtocolMapperEvaluationRepresentation rep = new ProtocolMapperEvaluationRepresentation();
        rep.setMapperId(mapper.getId());
        rep.setMapperName(mapper.getName());
        rep.setProtocolMapper(mapper.getProtocolMapper());
        if (mapperContainer.getId().equals(this.client.getId())) {
            rep.setContainerId(this.client.getId());
            rep.setContainerName("");
            rep.setContainerType("client");
        } else {
            ClientScopeModel clientScope = mapperContainer;
            rep.setContainerId(clientScope.getId());
            rep.setContainerName(clientScope.getName());
            rep.setContainerType("client-scope");
        }
        return rep;
    }

    @GET
    @Path(value="generate-example-userinfo")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Create JSON with payload of example user info")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=Map.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Map<String, Object> generateExampleUserinfo(@QueryParam(value="scope") String scopeParam, @QueryParam(value="userId") String userId) {
        this.auth.clients().requireView(this.client);
        UserModel user = this.getUserModel(userId);
        logger.debugf("generateExampleUserinfo invoked. User: %s", (Object)user.getUsername());
        return (Map)this.sessionAware(user, scopeParam, "", (userSession, clientSessionCtx, audienceClients) -> {
            AccessToken userInfo = new AccessToken();
            TokenManager tokenManager = new TokenManager();
            userInfo = tokenManager.transformUserInfoAccessToken(this.session, userInfo, (UserSessionModel)userSession, (ClientSessionContext)clientSessionCtx);
            return tokenManager.generateUserInfoClaims(userInfo, user);
        });
    }

    @GET
    @Path(value="generate-example-id-token")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Create JSON with payload of example id token")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=IDToken.class))}), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public IDToken generateExampleIdToken(@QueryParam(value="scope") String scopeParam, @QueryParam(value="userId") String userId, @QueryParam(value="audience") String audience) {
        this.auth.clients().requireView(this.client);
        UserModel user = this.getUserModel(userId);
        logger.debugf("generateExampleIdToken invoked. User: %s, Scope param: %s, Target Audience: %s", (Object)user.getUsername(), (Object)scopeParam);
        return (IDToken)this.sessionAware(user, scopeParam, audience, (userSession, clientSessionCtx, audienceClients) -> {
            TokenManager tokenManager = new TokenManager();
            TokenManager.AccessTokenResponseBuilder response = tokenManager.responseBuilder(this.realm, this.client, null, this.session, (UserSessionModel)userSession, (ClientSessionContext)clientSessionCtx).generateAccessToken().generateIDToken();
            IDToken idToken = response.getIdToken();
            AccessToken accessToken = response.getAccessToken();
            this.validateAudience(accessToken, (ClientModel[])audienceClients);
            return idToken;
        });
    }

    @GET
    @Path(value="generate-example-access-token")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Create JSON with payload of example access token")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=AccessToken.class))}), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public AccessToken generateExampleAccessToken(@QueryParam(value="scope") String scopeParam, @QueryParam(value="userId") String userId, @QueryParam(value="audience") String audience) {
        this.auth.clients().requireView(this.client);
        UserModel user = this.getUserModel(userId);
        logger.debugf("generateExampleAccessToken invoked. User: %s, Scope param: %s, Target Audience: %s", (Object)user.getUsername(), (Object)scopeParam, (Object)audience);
        return (AccessToken)this.sessionAware(user, scopeParam, audience, (userSession, clientSessionCtx, audienceClients) -> {
            TokenManager tokenManager = new TokenManager();
            AccessToken accessToken = tokenManager.responseBuilder(this.realm, this.client, null, this.session, (UserSessionModel)userSession, (ClientSessionContext)clientSessionCtx).generateAccessToken().getAccessToken();
            this.validateAudience(accessToken, (ClientModel[])audienceClients);
            return accessToken;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R sessionAware(UserModel user, String scopeParam, String audienceParam, TriFunction<UserSessionModel, ClientSessionContext, ClientModel[], R> function) {
        Object object;
        block6: {
            AuthenticationSessionModel authSession = null;
            UserSessionModel userSession = null;
            AuthenticationSessionManager authSessionManager = new AuthenticationSessionManager(this.session);
            try {
                RootAuthenticationSessionModel rootAuthSession = authSessionManager.createAuthenticationSession(this.realm, false);
                authSession = rootAuthSession.createAuthenticationSession(this.client);
                authSession.setAuthenticatedUser(user);
                authSession.setProtocol("openid-connect");
                authSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
                authSession.setClientNote("scope", scopeParam);
                userSession = new UserSessionManager(this.session).createUserSession(authSession.getParentSession().getId(), this.realm, user, user.getUsername(), this.clientConnection.getRemoteHost(), "example-auth", false, null, null, UserSessionModel.SessionPersistenceState.PERSISTENT);
                AuthenticationManager.setClientScopesInSession(this.session, authSession);
                ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
                ClientModel[] audienceClients = this.getClients(audienceParam);
                if (audienceClients.length > 0) {
                    clientSessionCtx.setAttribute("req-aud-clients", (Object)audienceClients);
                }
                object = function.apply((Object)userSession, (Object)clientSessionCtx, (Object)audienceClients);
                if (authSession != null) {
                    authSessionManager.removeAuthenticationSession(this.realm, authSession, false);
                }
                if (userSession == null) break block6;
            }
            catch (Throwable throwable) {
                if (authSession != null) {
                    authSessionManager.removeAuthenticationSession(this.realm, authSession, false);
                }
                if (userSession != null) {
                    this.session.sessions().removeUserSession(this.realm, userSession);
                }
                throw throwable;
            }
            this.session.sessions().removeUserSession(this.realm, userSession);
        }
        return (R)object;
    }

    private ClientModel[] getClients(String clientsStr) {
        ArrayList<ClientModel> clients = new ArrayList<ClientModel>();
        if (clientsStr != null && !clientsStr.isEmpty()) {
            for (String clientId : clientsStr.split("\\s+")) {
                ClientModel client = this.realm.getClientByClientId(clientId);
                if (client == null) continue;
                clients.add(client);
            }
        }
        return (ClientModel[])clients.toArray(ClientModel[]::new);
    }

    private void validateAudience(AccessToken accessToken, ClientModel[] requestedAudience) {
        List<String> requestedAudienceClientIds = Stream.of(requestedAudience).map(ClientModel::getClientId).collect(Collectors.toList());
        Set<String> missingAudience = TokenUtils.checkRequestedAudiences((JsonWebToken)accessToken, requestedAudienceClientIds);
        if (!missingAudience.isEmpty()) {
            String missingAudienceStr = CollectionUtil.join(missingAudience);
            throw new NotFoundException("Requested audience not available: " + missingAudienceStr);
        }
    }

    private UserModel getUserModel(String userId) {
        if (userId == null) {
            throw new NotFoundException("No userId provided");
        }
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user == null) {
            throw new NotFoundException("No user found");
        }
        return user;
    }

    public static class ProtocolMapperEvaluationRepresentation {
        @JsonProperty(value="mapperId")
        private String mapperId;
        @JsonProperty(value="mapperName")
        private String mapperName;
        @JsonProperty(value="containerId")
        private String containerId;
        @JsonProperty(value="containerName")
        private String containerName;
        @JsonProperty(value="containerType")
        private String containerType;
        @JsonProperty(value="protocolMapper")
        private String protocolMapper;

        public String getMapperId() {
            return this.mapperId;
        }

        public void setMapperId(String mapperId) {
            this.mapperId = mapperId;
        }

        public String getMapperName() {
            return this.mapperName;
        }

        public void setMapperName(String mapperName) {
            this.mapperName = mapperName;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public String getContainerType() {
            return this.containerType;
        }

        public void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        public String getProtocolMapper() {
            return this.protocolMapper;
        }

        public void setProtocolMapper(String protocolMapper) {
            this.protocolMapper = protocolMapper;
        }
    }
}

