/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;

class Helper {
    Helper() {
    }

    public static Policy addScopePermission(AuthorizationProvider authz, ResourceServer resourceServer, String name, Resource resource, Scope scope, Policy policy) {
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName(name);
        representation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        representation.setLogic(Logic.POSITIVE);
        representation.addResource(resource.getName());
        representation.addScope(new String[]{scope.getName()});
        representation.addPolicy(new String[]{policy.getName()});
        return authz.getStoreFactory().getPolicyStore().create(resourceServer, (AbstractPolicyRepresentation)representation);
    }

    public static Policy addEmptyScopePermission(AuthorizationProvider authz, ResourceServer resourceServer, String name, Resource resource, Scope scope) {
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setName(name);
        representation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        representation.setLogic(Logic.POSITIVE);
        representation.addResource(resource.getName());
        representation.addScope(new String[]{scope.getName()});
        return authz.getStoreFactory().getPolicyStore().create(resourceServer, (AbstractPolicyRepresentation)representation);
    }

    public static Policy createRolePolicy(AuthorizationProvider authz, ResourceServer resourceServer, RoleModel role) {
        String roleName = Helper.getRolePolicyName(role);
        return Helper.createRolePolicy(authz, resourceServer, role, roleName);
    }

    public static Policy createRolePolicy(AuthorizationProvider authz, ResourceServer resourceServer, RoleModel role, String policyName) {
        PolicyRepresentation representation = new PolicyRepresentation();
        representation.setName(policyName);
        representation.setType("role");
        representation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        representation.setLogic(Logic.POSITIVE);
        String roleValues = "[{\"id\":\"" + role.getId() + "\",\"required\": true}]";
        HashMap<String, CallSite> config = new HashMap<String, CallSite>();
        config.put("roles", (CallSite)((Object)roleValues));
        representation.setConfig(config);
        return authz.getStoreFactory().getPolicyStore().create(resourceServer, (AbstractPolicyRepresentation)representation);
    }

    public static String getRolePolicyName(RoleModel role) {
        Object roleName = "";
        if (role.getContainer() instanceof ClientModel) {
            ClientModel client = (ClientModel)role.getContainer();
            roleName = client.getClientId() + "." + role.getName();
        } else {
            roleName = role.getName();
        }
        roleName = "role.policy." + (String)roleName;
        return roleName;
    }
}

