/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import jakarta.ws.rs.core.UriBuilder;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.models.KeycloakSession;
import org.keycloak.urls.UrlType;

public class ResolveRelative {
    public static String resolveRelativeUri(KeycloakSession session, String rootUrl, String url) {
        String frontendUrl = session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString();
        String adminUrl = session.getContext().getUri(UrlType.ADMIN).getBaseUri().toString();
        return ResolveRelative.resolveRelativeUri(frontendUrl, adminUrl, rootUrl, url);
    }

    public static String resolveRelativeUri(String frontendUrl, String adminUrl, String rootUrl, String url) {
        Object finalUrl = url == null || !url.startsWith("/") ? url : (rootUrl != null && !rootUrl.isEmpty() ? ResolveRelative.resolveRootUrl(frontendUrl, adminUrl, rootUrl) + url : UriBuilder.fromUri((String)frontendUrl).replacePath(url).build(new Object[0]).toString());
        return StringPropertyReplacer.replaceProperties((String)finalUrl);
    }

    public static String resolveRootUrl(KeycloakSession session, String rootUrl) {
        String frontendUrl = session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString();
        String adminUrl = session.getContext().getUri(UrlType.ADMIN).getBaseUri().toString();
        return ResolveRelative.resolveRootUrl(frontendUrl, adminUrl, rootUrl);
    }

    public static String resolveRootUrl(String frontendUrl, String adminUrl, String rootUrl) {
        if (rootUrl != null) {
            if (rootUrl.equals("${authBaseUrl}")) {
                rootUrl = frontendUrl;
                if (rootUrl.endsWith("/")) {
                    rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
                }
            } else if (rootUrl.equals("${authAdminUrl}") && (rootUrl = adminUrl).endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
        }
        return rootUrl;
    }
}

