/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import org.keycloak.common.enums.HostnameVerificationPolicy;
import org.keycloak.truststore.JSSETruststoreConfigurator;
import org.keycloak.truststore.TruststoreProvider;

public class FileTruststoreProvider
implements TruststoreProvider {
    private final HostnameVerificationPolicy policy;
    private final SSLSocketFactory sslSocketFactory;
    private final KeyStore truststore;
    private final Map<X500Principal, List<X509Certificate>> rootCertificates;
    private final Map<X500Principal, List<X509Certificate>> intermediateCertificates;

    public FileTruststoreProvider(KeyStore truststore, HostnameVerificationPolicy policy, Map<X500Principal, List<X509Certificate>> rootCertificates, Map<X500Principal, List<X509Certificate>> intermediateCertificates) {
        this.policy = policy;
        this.truststore = truststore;
        this.rootCertificates = rootCertificates;
        this.intermediateCertificates = intermediateCertificates;
        SSLSocketFactory jsseSSLSocketFactory = new JSSETruststoreConfigurator(this).getSSLSocketFactory();
        this.sslSocketFactory = jsseSSLSocketFactory != null ? jsseSSLSocketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public HostnameVerificationPolicy getPolicy() {
        return this.policy;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public KeyStore getTruststore() {
        return this.truststore;
    }

    public Map<X500Principal, List<X509Certificate>> getRootCertificates() {
        return this.rootCertificates;
    }

    public Map<X500Principal, List<X509Certificate>> getIntermediateCertificates() {
        return this.intermediateCertificates;
    }

    public void close() {
    }
}

