/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.attribute;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.AttributedElement;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.UnboundAttribute;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RecordComponentInfo
extends AttributedElement {
    public Utf8Entry name();

    public Utf8Entry descriptor();

    default public ClassDesc descriptorSymbol() {
        return Util.fieldTypeSymbol(this.descriptor());
    }

    public static RecordComponentInfo of(Utf8Entry name, Utf8Entry descriptor, List<Attribute<?>> attributes) {
        return new UnboundAttribute.UnboundRecordComponentInfo(name, descriptor, attributes);
    }

    public static RecordComponentInfo of(Utf8Entry name, Utf8Entry descriptor, Attribute<?> ... attributes) {
        return RecordComponentInfo.of(name, descriptor, List.of(attributes));
    }

    public static RecordComponentInfo of(String name, ClassDesc descriptor, List<Attribute<?>> attributes) {
        return new UnboundAttribute.UnboundRecordComponentInfo(TemporaryConstantPool.INSTANCE.utf8Entry(name), TemporaryConstantPool.INSTANCE.utf8Entry(descriptor), attributes);
    }

    public static RecordComponentInfo of(String name, ClassDesc descriptor, Attribute<?> ... attributes) {
        return RecordComponentInfo.of(name, descriptor, List.of(attributes));
    }
}

