/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.AccessFlags;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeModel;
import io.github.dmlloyd.classfile.CodeTransform;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodElement;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.AbstractUnboundModel;
import io.github.dmlloyd.classfile.impl.AccessFlagsImpl;
import io.github.dmlloyd.classfile.impl.BufferedCodeBuilder;
import io.github.dmlloyd.classfile.impl.ClassFileImpl;
import io.github.dmlloyd.classfile.impl.DirectClassBuilder;
import io.github.dmlloyd.classfile.impl.MethodInfo;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.TerminalMethodBuilder;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class BufferedMethodBuilder
implements TerminalMethodBuilder {
    private final List<MethodElement> elements = new ArrayList<MethodElement>();
    private final SplitConstantPool constantPool;
    private final ClassFileImpl context;
    private final Utf8Entry name;
    private final Utf8Entry desc;
    private AccessFlags flags;
    private final MethodModel original;
    private int[] parameterSlots;

    public BufferedMethodBuilder(SplitConstantPool constantPool, ClassFileImpl context, Utf8Entry nameInfo, Utf8Entry typeInfo, int flags, MethodModel original) {
        this.constantPool = constantPool;
        this.context = context;
        this.name = Objects.requireNonNull(nameInfo);
        this.desc = Objects.requireNonNull(typeInfo);
        this.flags = new AccessFlagsImpl(AccessFlag.Location.METHOD, flags);
        this.original = original;
    }

    @Override
    public MethodBuilder with(MethodElement element) {
        this.elements.add(Objects.requireNonNull(element));
        if (element instanceof AccessFlags) {
            AccessFlags f = (AccessFlags)element;
            this.flags = this.checkFlags(f);
        }
        return this;
    }

    private AccessFlags checkFlags(AccessFlags updated) {
        boolean isStatic;
        boolean wasStatic = updated.has(AccessFlag.STATIC);
        if (wasStatic != (isStatic = this.flags.has(AccessFlag.STATIC))) {
            throw new IllegalArgumentException("Cannot change ACC_STATIC flag of method");
        }
        return updated;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    @Override
    public Utf8Entry methodName() {
        return this.name;
    }

    @Override
    public Utf8Entry methodType() {
        return this.desc;
    }

    @Override
    public MethodTypeDesc methodTypeSymbol() {
        return Util.methodTypeSymbol(this.methodType());
    }

    @Override
    public int methodFlags() {
        return this.flags.flagsMask();
    }

    @Override
    public int parameterSlot(int paramNo) {
        if (this.parameterSlots == null) {
            this.parameterSlots = Util.parseParameterSlots(this.methodFlags(), this.methodTypeSymbol());
        }
        return this.parameterSlots[paramNo];
    }

    @Override
    public MethodBuilder withCode(Consumer<? super CodeBuilder> handler) {
        return this.with(new BufferedCodeBuilder(this, this.constantPool, this.context, null).run(handler).toModel());
    }

    @Override
    public MethodBuilder transformCode(CodeModel code, CodeTransform transform) {
        BufferedCodeBuilder builder = new BufferedCodeBuilder(this, this.constantPool, this.context, code);
        builder.transform(code, transform);
        return this.with(builder.toModel());
    }

    @Override
    public BufferedCodeBuilder bufferedCodeBuilder(CodeModel original) {
        return new BufferedCodeBuilder(this, this.constantPool, this.context, original);
    }

    public BufferedMethodBuilder run(Consumer<? super MethodBuilder> handler) {
        handler.accept(this);
        return this;
    }

    public MethodModel toModel() {
        return new Model();
    }

    public final class Model
    extends AbstractUnboundModel<MethodElement>
    implements MethodModel,
    MethodInfo {
        public Model() {
            super(BufferedMethodBuilder.this.elements);
        }

        @Override
        public AccessFlags flags() {
            return BufferedMethodBuilder.this.flags;
        }

        @Override
        public Optional<ClassModel> parent() {
            return Optional.empty();
        }

        @Override
        public Utf8Entry methodName() {
            return BufferedMethodBuilder.this.name;
        }

        @Override
        public Utf8Entry methodType() {
            return BufferedMethodBuilder.this.desc;
        }

        @Override
        public MethodTypeDesc methodTypeSymbol() {
            return BufferedMethodBuilder.this.methodTypeSymbol();
        }

        @Override
        public int methodFlags() {
            return BufferedMethodBuilder.this.flags.flagsMask();
        }

        @Override
        public int parameterSlot(int paramNo) {
            return BufferedMethodBuilder.this.parameterSlot(paramNo);
        }

        @Override
        public Optional<CodeModel> code() {
            return this.elements.stream().mapMulti((e, sink) -> {
                if (e instanceof CodeModel) {
                    CodeModel cm = (CodeModel)e;
                    sink.accept(cm);
                }
            }).findFirst();
        }

        @Override
        public void writeTo(DirectClassBuilder builder) {
            builder.withMethod(this.methodName(), this.methodType(), this.methodFlags(), Util.writingAll(this));
        }

        public String toString() {
            return String.format("MethodModel[methodName=%s, methodType=%s, flags=%d]", BufferedMethodBuilder.this.name.stringValue(), BufferedMethodBuilder.this.desc.stringValue(), BufferedMethodBuilder.this.flags.flagsMask());
        }
    }
}

