/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.AccessFlags;
import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.ClassReader;
import io.github.dmlloyd.classfile.FieldElement;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.AccessFlagsImpl;
import io.github.dmlloyd.classfile.impl.BoundAttribute;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.ClassReaderImpl;
import io.github.dmlloyd.classfile.impl.DirectClassBuilder;
import io.github.dmlloyd.classfile.impl.Util;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public final class FieldImpl
extends AbstractElement
implements FieldModel,
Util.Writable {
    private final ClassReader reader;
    private final int startPos;
    private final int endPos;
    private final int attributesPos;
    private List<Attribute<?>> attributes;

    public FieldImpl(ClassReader reader, int startPos, int endPos, int attributesPos) {
        this.reader = reader;
        this.startPos = startPos;
        this.endPos = endPos;
        this.attributesPos = attributesPos;
    }

    @Override
    public AccessFlags flags() {
        return new AccessFlagsImpl(AccessFlag.Location.FIELD, this.reader.readU2(this.startPos));
    }

    @Override
    public Optional<ClassModel> parent() {
        ClassReader classReader = this.reader;
        if (classReader instanceof ClassReaderImpl) {
            ClassReaderImpl cri = (ClassReaderImpl)classReader;
            return Optional.of(cri.getContainedClass());
        }
        return Optional.empty();
    }

    @Override
    public Utf8Entry fieldName() {
        return this.reader.readEntry(this.startPos + 2, Utf8Entry.class);
    }

    @Override
    public Utf8Entry fieldType() {
        return this.reader.readEntry(this.startPos + 4, Utf8Entry.class);
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(this, this.reader, this.attributesPos, this.reader.customAttributes());
        }
        return this.attributes;
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        if (buf.canWriteDirect(this.reader)) {
            this.reader.copyBytesTo(buf, this.startPos, this.endPos - this.startPos);
        } else {
            buf.writeU2U2U2(this.flags().flagsMask(), buf.cpIndex(this.fieldName()), buf.cpIndex(this.fieldType()));
            Util.writeAttributes(buf, this.attributes());
        }
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        if (builder.canWriteDirect(this.reader)) {
            builder.withField(this);
        } else {
            builder.withField(this.fieldName(), this.fieldType(), Util.writingAll(this));
        }
    }

    @Override
    public void forEach(Consumer<? super FieldElement> consumer) {
        consumer.accept(this.flags());
        for (Attribute<?> attr : this.attributes()) {
            if (!(attr instanceof FieldElement)) continue;
            FieldElement e = (FieldElement)((Object)attr);
            consumer.accept(e);
        }
    }

    public String toString() {
        return String.format("FieldModel[fieldName=%s, fieldType=%s, flags=%d]", this.fieldName().stringValue(), this.fieldType().stringValue(), this.flags().flagsMask());
    }
}

