/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.WireType;

public class MapDescriptor
extends FieldDescriptor {
    private final String keyTypeName;
    private final Type keyType;
    private final Descriptor descriptor;

    private MapDescriptor(Builder builder) {
        super(builder);
        this.keyTypeName = builder.keyTypeName;
        this.keyType = Type.primitiveFromString(this.keyTypeName);
        Descriptor.Builder b = new Descriptor.Builder().withName(this.name).withFullName(this.fullName);
        FieldDescriptor.Builder kb = new FieldDescriptor.Builder().withNumber(1).withName("key").withTypeName(this.keyTypeName);
        b.addField(kb);
        FieldDescriptor.Builder vb = new FieldDescriptor.Builder().withNumber(2).withName("value").withTypeName(this.typeName);
        b.addField(vb);
        this.descriptor = b.build();
    }

    public Descriptor asDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean isRepeated() {
        return true;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public String getKeyTypeName() {
        return this.keyTypeName;
    }

    public JavaType getKeyJavaType() {
        return this.getKeyType().getJavaType();
    }

    @Override
    public int getWireTag() {
        return WireType.makeTag(this.number, WireType.LENGTH_DELIMITED);
    }

    public int getKeyWireTag() {
        return WireType.makeTag(1, this.keyType.getWireType());
    }

    public int getValueWireTag() {
        return WireType.makeTag(2, this.type.getWireType());
    }

    @Override
    public Label getLabel() {
        return Label.OPTIONAL;
    }

    @Override
    void setMessageType(Descriptor descriptor) {
        super.setMessageType(descriptor);
        this.descriptor.getFields().get(1).setMessageType(descriptor);
    }

    @Override
    void setEnumType(EnumDescriptor enumDescriptor) {
        super.setEnumType(enumDescriptor);
        this.descriptor.getFields().get(1).setEnumType(enumDescriptor);
    }

    @Override
    public String toString() {
        return "MapDescriptor{keyTypeName='" + this.keyTypeName + "', valueTypeName='" + this.typeName + "', name='" + this.name + "', number='" + this.number + "'}";
    }

    public static class Builder
    extends FieldDescriptor.Builder {
        String keyTypeName;

        @Override
        public Builder withName(String name) {
            super.withName(name);
            return this;
        }

        public Builder withKeyTypeName(String keyTypeName) {
            this.keyTypeName = keyTypeName;
            return this;
        }

        public Builder withValueTypeName(String valueTypeName) {
            this.withTypeName(valueTypeName);
            return this;
        }

        @Override
        public MapDescriptor build() {
            return new MapDescriptor(this);
        }
    }
}

