/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeArrayAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueStatelessMarshaler;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import io.opentelemetry.proto.common.v1.internal.KeyValue;
import java.io.IOException;
import java.util.List;

public final class AttributeKeyValueStatelessMarshaler
implements StatelessMarshaler2<AttributeKey<?>, Object> {
    public static final AttributeKeyValueStatelessMarshaler INSTANCE = new AttributeKeyValueStatelessMarshaler();
    private static final byte[] EMPTY_BYTES = new byte[0];

    private AttributeKeyValueStatelessMarshaler() {
    }

    public void writeTo(Serializer output, AttributeKey<?> attributeKey, Object value, MarshalerContext context) throws IOException {
        if (attributeKey.getKey().isEmpty()) {
            output.serializeString(KeyValue.KEY, EMPTY_BYTES);
        } else if (attributeKey instanceof InternalAttributeKeyImpl) {
            byte[] keyUtf8 = ((InternalAttributeKeyImpl)attributeKey).getKeyUtf8();
            output.serializeString(KeyValue.KEY, keyUtf8);
        } else {
            output.serializeStringWithContext(KeyValue.KEY, attributeKey.getKey(), context);
        }
        output.serializeMessageWithContext(KeyValue.VALUE, attributeKey, value, (StatelessMarshaler2)ValueStatelessMarshaler.INSTANCE, context);
    }

    public int getBinarySerializedSize(AttributeKey<?> attributeKey, Object value, MarshalerContext context) {
        int size = 0;
        if (!attributeKey.getKey().isEmpty()) {
            if (attributeKey instanceof InternalAttributeKeyImpl) {
                byte[] keyUtf8 = ((InternalAttributeKeyImpl)attributeKey).getKeyUtf8();
                size += MarshalerUtil.sizeBytes((ProtoFieldInfo)KeyValue.KEY, (byte[])keyUtf8);
            } else {
                return StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)KeyValue.KEY, (String)attributeKey.getKey(), (MarshalerContext)context);
            }
        }
        return size += StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)KeyValue.VALUE, attributeKey, (Object)value, (StatelessMarshaler2)ValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
    }

    private static class ValueStatelessMarshaler
    implements StatelessMarshaler2<AttributeKey<?>, Object> {
        static final ValueStatelessMarshaler INSTANCE = new ValueStatelessMarshaler();

        private ValueStatelessMarshaler() {
        }

        public int getBinarySerializedSize(AttributeKey<?> attributeKey, Object value, MarshalerContext context) {
            AttributeType attributeType = attributeKey.getType();
            switch (attributeType) {
                case STRING: {
                    return StringAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((String)value, context);
                }
                case LONG: {
                    return IntAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Long)value, context);
                }
                case BOOLEAN: {
                    return BoolAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Boolean)value, context);
                }
                case DOUBLE: {
                    return DoubleAnyValueStatelessMarshaler.INSTANCE.getBinarySerializedSize((Double)value, context);
                }
                case STRING_ARRAY: 
                case LONG_ARRAY: 
                case BOOLEAN_ARRAY: 
                case DOUBLE_ARRAY: {
                    return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)AnyValue.ARRAY_VALUE, (Object)attributeType, (Object)((List)value), AttributeArrayAnyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
                }
            }
            throw new IllegalArgumentException("Unsupported attribute type.");
        }

        public void writeTo(Serializer output, AttributeKey<?> attributeKey, Object value, MarshalerContext context) throws IOException {
            AttributeType attributeType = attributeKey.getType();
            switch (attributeType) {
                case STRING: {
                    StringAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (String)value, context);
                    return;
                }
                case LONG: {
                    IntAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Long)value, context);
                    return;
                }
                case BOOLEAN: {
                    BoolAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Boolean)value, context);
                    return;
                }
                case DOUBLE: {
                    DoubleAnyValueStatelessMarshaler.INSTANCE.writeTo(output, (Double)value, context);
                    return;
                }
                case STRING_ARRAY: 
                case LONG_ARRAY: 
                case BOOLEAN_ARRAY: 
                case DOUBLE_ARRAY: {
                    output.serializeMessageWithContext(AnyValue.ARRAY_VALUE, (Object)attributeType, (Object)((List)value), AttributeArrayAnyValueStatelessMarshaler.INSTANCE, context);
                    return;
                }
            }
            throw new IllegalArgumentException("Unsupported attribute type.");
        }
    }
}

