/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.util;

import java.util.Objects;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.w3c.dom.Element;

public class KeycloakKeySamlExtensionGenerator
implements SamlProtocolExtensionsAwareBuilder.NodeGenerator {
    public static final String NS_URI = "urn:keycloak:ext:key:1.0";
    public static final String NS_PREFIX = "kckey";
    public static final String KC_KEY_INFO_ELEMENT_NAME = "KeyInfo";
    public static final String KEY_ID_ATTRIBUTE_NAME = "MessageSigningKeyId";
    private final String keyId;

    public KeycloakKeySamlExtensionGenerator(String keyId) {
        this.keyId = keyId;
    }

    @Override
    public void write(XMLStreamWriter writer) throws ProcessingException {
        StaxUtil.writeStartElement(writer, NS_PREFIX, KC_KEY_INFO_ELEMENT_NAME, NS_URI);
        StaxUtil.writeNameSpace(writer, NS_PREFIX, NS_URI);
        if (this.keyId != null) {
            StaxUtil.writeAttribute(writer, KEY_ID_ATTRIBUTE_NAME, this.keyId);
        }
        StaxUtil.writeEndElement(writer);
        StaxUtil.flush(writer);
    }

    public static String getMessageSigningKeyIdFromElement(Element element) {
        if (Objects.equals(element.getNamespaceURI(), NS_URI) && Objects.equals(element.getLocalName(), KC_KEY_INFO_ELEMENT_NAME) && element.hasAttribute(KEY_ID_ATTRIBUTE_NAME)) {
            return element.getAttribute(KEY_ID_ATTRIBUTE_NAME);
        }
        return null;
    }
}

