/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.pretty.MessageHelper;

public class EntityVerifyVersionProcess
implements BeforeTransactionCompletionProcess {
    private final Object object;

    public EntityVerifyVersionProcess(Object object) {
        this.object = object;
    }

    @Override
    public void doBeforeTransactionCompletion(SessionImplementor session) {
        EntityEntry entry = session.getPersistenceContext().getEntry(this.object);
        if (entry != null) {
            Object latestVersion = entry.getPersister().getCurrentVersion(entry.getId(), session);
            if (!entry.getVersion().equals(latestVersion)) {
                throw new OptimisticEntityLockException(this.object, "Newer version [" + String.valueOf(latestVersion) + "] of entity [" + MessageHelper.infoString(entry.getEntityName(), entry.getId()) + "] found in database");
            }
        }
    }
}

