/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.persister.entity.DiscriminatorHelper;

public class DiscriminatorColumnSecondPass
implements SecondPass {
    private final String rootEntityName;
    private final Dialect dialect;

    public DiscriminatorColumnSecondPass(String rootEntityName, Dialect dialect) {
        this.rootEntityName = rootEntityName;
        this.dialect = dialect;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        PersistentClass rootClass = persistentClasses.get(this.rootEntityName);
        if (this.hasNullDiscriminatorValue(rootClass)) {
            for (Selectable selectable : rootClass.getDiscriminator().getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                column.setNullable(true);
            }
        }
        if (!(this.hasNotNullDiscriminatorValue(rootClass) || rootClass.getDiscriminator().hasFormula() || rootClass.isForceDiscriminator())) {
            Column column = rootClass.getDiscriminator().getColumns().get(0);
            column.addCheckConstraint(new CheckConstraint(this.checkConstraint(rootClass, column)));
        }
    }

    private boolean hasNullDiscriminatorValue(PersistentClass rootClass) {
        if (rootClass.isDiscriminatorValueNull()) {
            return true;
        }
        for (Subclass subclass : rootClass.getSubclasses()) {
            if (!subclass.isDiscriminatorValueNull()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNotNullDiscriminatorValue(PersistentClass rootClass) {
        if (rootClass.isDiscriminatorValueNotNull()) {
            return true;
        }
        for (Subclass subclass : rootClass.getSubclasses()) {
            if (!subclass.isDiscriminatorValueNotNull()) continue;
            return true;
        }
        return false;
    }

    private String checkConstraint(PersistentClass rootClass, Column column) {
        return this.dialect.getCheckCondition(column.getQuotedName(this.dialect), DiscriminatorColumnSecondPass.discriminatorValues(rootClass), column.getType().getJdbcType());
    }

    private static List<String> discriminatorValues(PersistentClass rootClass) {
        ArrayList<String> values = new ArrayList<String>();
        if (!(rootClass.isAbstract().booleanValue() || rootClass.isDiscriminatorValueNull() || rootClass.isDiscriminatorValueNotNull())) {
            values.add(DiscriminatorHelper.getDiscriminatorValue(rootClass).toString());
        }
        for (Subclass subclass : rootClass.getSubclasses()) {
            if (subclass.isAbstract().booleanValue() || subclass.isDiscriminatorValueNull() || subclass.isDiscriminatorValueNotNull()) continue;
            values.add(DiscriminatorHelper.getDiscriminatorValue(subclass).toString());
        }
        return values;
    }
}

