/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.GeneratorParameters;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.generator.AnnotationBasedGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.uuid.UuidGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;

public class GeneratorAnnotationHelper {
    public static <A extends Annotation> A findLocalizedMatch(AnnotationDescriptor<A> generatorAnnotationType, MemberDetails idMember, ClassDetails entityType, @Nullable Function<A, String> nameExtractor, @Nullable String matchName, MetadataBuildingContext context) {
        String registrationName;
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        Annotation possibleMatch = null;
        for (Annotation generatorAnnotation : idMember.getRepeatedAnnotationUsages(generatorAnnotationType, modelsContext)) {
            if (nameExtractor != null) {
                registrationName = nameExtractor.apply(generatorAnnotation);
                if (registrationName.isEmpty()) {
                    possibleMatch = generatorAnnotation;
                    continue;
                }
                if (!registrationName.equals(matchName)) continue;
                return (A)generatorAnnotation;
            }
            return (A)generatorAnnotation;
        }
        for (Annotation generatorAnnotation : entityType.getRepeatedAnnotationUsages(generatorAnnotationType, modelsContext)) {
            if (nameExtractor != null) {
                registrationName = nameExtractor.apply(generatorAnnotation);
                if (registrationName.isEmpty()) {
                    if (possibleMatch != null) continue;
                    possibleMatch = generatorAnnotation;
                    continue;
                }
                if (!registrationName.equals(matchName)) continue;
                return (A)generatorAnnotation;
            }
            return (A)generatorAnnotation;
        }
        for (Annotation generatorAnnotation : idMember.getDeclaringType().getRepeatedAnnotationUsages(generatorAnnotationType, modelsContext)) {
            if (nameExtractor != null) {
                registrationName = nameExtractor.apply(generatorAnnotation);
                if (registrationName.isEmpty()) {
                    if (possibleMatch != null) continue;
                    possibleMatch = generatorAnnotation;
                    continue;
                }
                if (!registrationName.equals(matchName)) continue;
                return (A)generatorAnnotation;
            }
            return (A)generatorAnnotation;
        }
        ClassDetails packageInfo = GeneratorAnnotationHelper.locatePackageInfoDetails(idMember.getDeclaringType(), context);
        if (packageInfo != null) {
            for (Annotation generatorAnnotation : packageInfo.getRepeatedAnnotationUsages(generatorAnnotationType, modelsContext)) {
                if (nameExtractor != null) {
                    String registrationName2 = nameExtractor.apply(generatorAnnotation);
                    if (registrationName2.isEmpty()) {
                        if (possibleMatch != null) continue;
                        possibleMatch = generatorAnnotation;
                        continue;
                    }
                    if (!registrationName2.equals(matchName)) continue;
                    return (A)generatorAnnotation;
                }
                return (A)generatorAnnotation;
            }
        }
        return (A)possibleMatch;
    }

    public static ClassDetails locatePackageInfoDetails(ClassDetails classDetails, MetadataBuildingContext buildingContext) {
        ModelsContext modelsContext = buildingContext.getBootstrapContext().getModelsContext();
        return GeneratorAnnotationHelper.locatePackageInfoDetails(classDetails, modelsContext);
    }

    public static ClassDetails locatePackageInfoDetails(ClassDetails classDetails, ModelsContext modelContext) {
        return GeneratorAnnotationHelper.locatePackageInfoDetails(classDetails, modelContext.getClassDetailsRegistry());
    }

    public static ClassDetails locatePackageInfoDetails(ClassDetails classDetails, ClassDetailsRegistry classDetailsRegistry) {
        String packageInfoFqn = StringHelper.qualifier(classDetails.getName()) + ".package-info";
        try {
            return classDetailsRegistry.resolveClassDetails(packageInfoFqn);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    public static void handleSequenceGenerator(String nameFromGeneratedValue, SequenceGenerator generatorAnnotation, SimpleValue idValue, MemberDetails idMember, MetadataBuildingContext buildingContext) {
        idValue.setCustomIdGeneratorCreator(creationContext -> {
            SequenceStyleGenerator identifierGenerator = GeneratorBinder.instantiateGenerator(GeneratorBinder.beanContainer(buildingContext), SequenceStyleGenerator.class);
            GeneratorAnnotationHelper.prepareForUse(identifierGenerator, generatorAnnotation, idMember, properties -> {
                if (generatorAnnotation != null) {
                    properties.put("GENERATOR_NAME", generatorAnnotation.name());
                } else if (nameFromGeneratedValue != null) {
                    properties.put("GENERATOR_NAME", nameFromGeneratedValue);
                }
                properties.put("increment_size", (Object)GeneratorParameters.fallbackAllocationSize((Annotation)generatorAnnotation, buildingContext));
            }, generatorAnnotation == null ? null : (a, properties) -> SequenceStyleGenerator.applyConfiguration(generatorAnnotation, properties::put), creationContext);
            return identifierGenerator;
        });
    }

    public static void handleTableGenerator(String nameFromGeneratedValue, TableGenerator generatorAnnotation, SimpleValue idValue, MemberDetails idMember, MetadataBuildingContext buildingContext) {
        idValue.setCustomIdGeneratorCreator(creationContext -> {
            org.hibernate.id.enhanced.TableGenerator identifierGenerator = GeneratorBinder.instantiateGenerator(GeneratorBinder.beanContainer(buildingContext), org.hibernate.id.enhanced.TableGenerator.class);
            GeneratorAnnotationHelper.prepareForUse(identifierGenerator, generatorAnnotation, idMember, properties -> {
                if (generatorAnnotation != null) {
                    properties.put("GENERATOR_NAME", generatorAnnotation.name());
                } else if (nameFromGeneratedValue != null) {
                    properties.put("GENERATOR_NAME", nameFromGeneratedValue);
                }
                properties.put("increment_size", (Object)GeneratorParameters.fallbackAllocationSize((Annotation)generatorAnnotation, buildingContext));
            }, generatorAnnotation == null ? null : (a, properties) -> org.hibernate.id.enhanced.TableGenerator.applyConfiguration(generatorAnnotation, properties::put), creationContext);
            return identifierGenerator;
        });
    }

    public static void handleIdGeneratorType(Annotation generatorAnnotation, SimpleValue idValue, MemberDetails idMember, MetadataBuildingContext buildingContext) {
        IdGeneratorType markerAnnotation = generatorAnnotation.annotationType().getAnnotation(IdGeneratorType.class);
        idValue.setCustomIdGeneratorCreator(creationContext -> {
            Generator identifierGenerator = GeneratorBinder.instantiateGenerator(GeneratorBinder.beanContainer(buildingContext), markerAnnotation.value());
            GeneratorAnnotationHelper.prepareForUse(identifierGenerator, generatorAnnotation, idMember, null, null, creationContext);
            return identifierGenerator;
        });
    }

    public static <A extends Annotation> void prepareForUse(Generator generator, A annotation, MemberDetails idMember, Consumer<Properties> configBaseline, BiConsumer<A, Properties> configExtractor, GeneratorCreationContext creationContext) {
        Configurable configurable;
        if (generator instanceof AnnotationBasedGenerator) {
            AnnotationBasedGenerator generation = (AnnotationBasedGenerator)generator;
            generation.initialize(annotation, idMember.toJavaMember(), creationContext);
        }
        if (generator instanceof Configurable) {
            configurable = (Configurable)((Object)generator);
            Properties properties = new Properties();
            if (configBaseline != null) {
                configBaseline.accept(properties);
            }
            GeneratorParameters.collectBaselineProperties(creationContext.getProperty() != null ? creationContext.getProperty().getValue() : creationContext.getPersistentClass().getIdentifierProperty().getValue(), creationContext.getDatabase().getDialect(), creationContext.getRootClass(), properties::setProperty, creationContext.getServiceRegistry().requireService(ConfigurationService.class));
            if (configExtractor != null) {
                configExtractor.accept(annotation, properties);
            }
            configurable.configure(creationContext, properties);
        }
        if (generator instanceof ExportableProducer) {
            ExportableProducer exportableProducer = (ExportableProducer)((Object)generator);
            exportableProducer.registerExportables(creationContext.getDatabase());
        }
        if (generator instanceof Configurable) {
            configurable = (Configurable)((Object)generator);
            configurable.initialize(creationContext.getSqlStringGenerationContext());
        }
    }

    public static void handleUuidStrategy(SimpleValue idValue, MemberDetails idMember, ClassDetails entityClass, MetadataBuildingContext context) {
        org.hibernate.annotations.UuidGenerator generatorConfig = (org.hibernate.annotations.UuidGenerator)GeneratorAnnotationHelper.findLocalizedMatch(HibernateAnnotations.UUID_GENERATOR, idMember, entityClass, null, null, context);
        idValue.setCustomIdGeneratorCreator(creationContext -> new UuidGenerator(generatorConfig, idMember));
    }

    public static void handleIdentityStrategy(SimpleValue idValue) {
        idValue.setCustomIdGeneratorCreator(creationContext -> new IdentityGenerator());
        idValue.setColumnToIdentity();
    }

    public static void handleGenericGenerator(String generatorName, GenericGenerator generatorConfig, PersistentClass entityMapping, SimpleValue idValue, MetadataBuildingContext context) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        ConfigurationHelper.setIfNotEmpty(generatorConfig.name(), "GENERATOR_NAME", configuration);
        configuration.put("entity_name", entityMapping.getEntityName());
        configuration.put("jpa_entity_name", entityMapping.getJpaEntityName());
        GeneratorAnnotationHelper.applyAnnotationParameters(generatorConfig, configuration);
        configuration.put("target_table", idValue.getTable().getName());
        if (idValue.getColumnSpan() == 1) {
            configuration.put("target_column", idValue.getColumns().get(0).getName());
        }
        GeneratorBinder.createGeneratorFrom(new IdentifierGeneratorDefinition(generatorName, GeneratorAnnotationHelper.determineStrategyName(generatorConfig), configuration), idValue, context);
    }

    private static String determineStrategyName(GenericGenerator generatorConfig) {
        Class<? extends Generator> type = generatorConfig.type();
        return !Objects.equals(type, Generator.class) ? type.getName() : generatorConfig.strategy();
    }

    private static void applyAnnotationParameters(GenericGenerator generatorConfig, Map<String, String> configuration) {
        for (Parameter parameter : generatorConfig.parameters()) {
            configuration.put(parameter.name(), parameter.value());
        }
    }
}

