/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models;

import java.util.EnumSet;
import org.hibernate.AnnotationException;
import org.hibernate.Incubating;
import org.hibernate.boot.models.AttributeNature;

@Incubating
public class MultipleAttributeNaturesException
extends AnnotationException {
    private final String attributeName;

    public MultipleAttributeNaturesException(String attributeName, EnumSet<AttributeNature> natures) {
        super(MultipleAttributeNaturesException.craftMessage(attributeName, natures));
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    private static String craftMessage(String attributeName, EnumSet<AttributeNature> natures) {
        StringBuilder buffer = new StringBuilder("Attribute `").append(attributeName).append("` expressed multiple natures [");
        String separator = "";
        for (AttributeNature nature : natures) {
            buffer.append(separator);
            buffer.append(nature.name());
            separator = ",";
        }
        return buffer.append("]").toString();
    }
}

