/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.spi;

import java.util.function.BiConsumer;
import org.hibernate.boot.internal.RootMappingDefaults;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.models.xml.internal.ManagedTypeProcessor;
import org.hibernate.boot.models.xml.internal.XmlDocumentContextImpl;
import org.hibernate.boot.models.xml.internal.XmlProcessingResultImpl;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.models.xml.spi.XmlDocument;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.boot.models.xml.spi.XmlPreProcessingResult;
import org.hibernate.boot.models.xml.spi.XmlProcessingResult;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.models.spi.ModelsContext;

public class XmlProcessor {
    public static XmlProcessingResult processXml(XmlPreProcessingResult xmlPreProcessingResult, PersistenceUnitMetadata persistenceUnitMetadata, BiConsumer<JaxbEntityMappingsImpl, XmlDocumentContext> jaxbRootConsumer, ModelsContext ModelsContext2, BootstrapContext bootstrapContext, RootMappingDefaults mappingDefaults) {
        boolean xmlMappingsGloballyComplete = persistenceUnitMetadata.areXmlMappingsComplete();
        XmlProcessingResultImpl xmlOverlay = new XmlProcessingResultImpl();
        xmlPreProcessingResult.getDocuments().forEach(xmlDocument -> {
            XmlDocumentContextImpl xmlDocumentContext = new XmlDocumentContextImpl((XmlDocument)xmlDocument, mappingDefaults, ModelsContext2, bootstrapContext);
            JaxbEntityMappingsImpl jaxbRoot = xmlDocument.getRoot();
            jaxbRootConsumer.accept(jaxbRoot, xmlDocumentContext);
            jaxbRoot.getEmbeddables().forEach(jaxbEmbeddable -> {
                if (xmlMappingsGloballyComplete || jaxbEmbeddable.isMetadataComplete() == Boolean.TRUE) {
                    ManagedTypeProcessor.processCompleteEmbeddable(jaxbRoot, jaxbEmbeddable, xmlDocumentContext);
                } else {
                    xmlOverlay.addEmbeddableOverride(new XmlProcessingResult.OverrideTuple<JaxbEmbeddableImpl>(jaxbRoot, xmlDocumentContext, (JaxbEmbeddableImpl)jaxbEmbeddable));
                }
            });
            jaxbRoot.getMappedSuperclasses().forEach(jaxbMappedSuperclass -> {
                if (xmlMappingsGloballyComplete || jaxbMappedSuperclass.isMetadataComplete() == Boolean.TRUE) {
                    ManagedTypeProcessor.processCompleteMappedSuperclass(jaxbRoot, jaxbMappedSuperclass, xmlDocumentContext);
                } else {
                    xmlOverlay.addMappedSuperclassesOverride(new XmlProcessingResult.OverrideTuple<JaxbMappedSuperclassImpl>(jaxbRoot, xmlDocumentContext, (JaxbMappedSuperclassImpl)jaxbMappedSuperclass));
                }
            });
            jaxbRoot.getEntities().forEach(jaxbEntity -> {
                if (xmlMappingsGloballyComplete || jaxbEntity.isMetadataComplete() == Boolean.TRUE) {
                    ManagedTypeProcessor.processCompleteEntity(jaxbRoot, jaxbEntity, xmlDocumentContext);
                } else {
                    xmlOverlay.addEntityOverride(new XmlProcessingResult.OverrideTuple<JaxbEntityImpl>(jaxbRoot, xmlDocumentContext, (JaxbEntityImpl)jaxbEntity));
                }
            });
        });
        return xmlOverlay;
    }
}

