/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.MySQLServerConfiguration;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.MySQLAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.MariaDBIdentityColumnSupport;
import org.hibernate.dialect.lock.internal.MariaDBLockingSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.sequence.MariaDBSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sql.ast.MariaDBSqlAstTranslator;
import org.hibernate.dialect.type.MariaDBCastingJsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.MariaDBCastingJsonJdbcType;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.SnapshotIsolationException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorMariaDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharUUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class MariaDBDialect
extends MySQLDialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(10, 6);
    private static final DatabaseVersion MYSQL57 = DatabaseVersion.make(5, 7);
    private static final Set<String> GEOMETRY_TYPE_NAMES = Set.of("POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION", "GEOMETRY");
    private final LockingSupport lockingSupport;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> switch (sqle.getErrorCode()) {
        case 1062 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" for key '", "'", sqle.getMessage());
        case 1451, 1452, 4025 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" CONSTRAINT `", "`", sqle.getMessage());
        case 3819 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" constraint '", "'", sqle.getMessage());
        case 1048 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Column '", "'", sqle.getMessage());
        case 1364 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Field '", "'", sqle.getMessage());
        default -> null;
    });

    public MariaDBDialect() {
        this(MINIMUM_VERSION);
    }

    public MariaDBDialect(DatabaseVersion version) {
        super(version);
        this.lockingSupport = new MariaDBLockingSupport(version);
    }

    public MariaDBDialect(DialectResolutionInfo info) {
        super(MariaDBDialect.createVersion(info, MINIMUM_VERSION), MySQLServerConfiguration.fromDialectResolutionInfo(info));
        this.lockingSupport = new MariaDBLockingSupport(this.getVersion());
        this.registerKeywords(info);
    }

    @Override
    public DatabaseVersion getMySQLVersion() {
        return MYSQL57;
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory commonFunctionFactory = new CommonFunctionFactory(functionContributions);
        commonFunctionFactory.windowFunctions();
        commonFunctionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionContributions.getFunctionRegistry().registerNamed("json_valid", functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN));
        commonFunctionFactory.jsonValue_mariadb();
        commonFunctionFactory.jsonArray_mariadb();
        commonFunctionFactory.jsonQuery_mariadb();
        commonFunctionFactory.jsonArrayAgg_mariadb();
        commonFunctionFactory.jsonObjectAgg_mariadb();
        commonFunctionFactory.jsonArrayAppend_mariadb();
        commonFunctionFactory.unnest_emulated();
        commonFunctionFactory.jsonTable_mysql();
        commonFunctionFactory.inverseDistributionOrderedSetAggregates_windowEmulation();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("median", "median(?1) over ()").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isSameOrAfter(10, 7)) {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
        }
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return MySQLAggregateSupport.forMariaDB(this);
    }

    @Override
    protected void registerKeyword(String word) {
        if (!"string".equalsIgnoreCase(word)) {
            super.registerKeyword(word);
        }
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                if (!columnTypeName.equals("uuid")) break;
                jdbcTypeCode = 3000;
                break;
            }
            case -3: {
                if (!GEOMETRY_TYPE_NAMES.contains(columnTypeName)) break;
                jdbcTypeCode = 3200;
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptorIfAbsent(3001, MariaDBCastingJsonJdbcType.INSTANCE);
        jdbcTypeRegistry.addTypeConstructorIfAbsent(MariaDBCastingJsonArrayJdbcTypeConstructor.INSTANCE);
        super.contributeTypes(typeContributions, serviceRegistry);
        if (this.getVersion().isSameOrAfter(10, 7)) {
            jdbcTypeRegistry.addDescriptorIfAbsent(VarcharUUIDJdbcType.INSTANCE);
        }
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        return to == CastType.JSON ? "json_extract(?1,'$')" : super.castPattern(from, to);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MariaDBSqlAstTranslator(sessionFactory, statement, MariaDBDialect.this);
            }
        };
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return false;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsColumnCheck() {
        return true;
    }

    @Override
    public boolean supportsNamedColumnCheck() {
        return false;
    }

    @Override
    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return MariaDBSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getSequenceSupport().supportsSequences() ? "select table_name from information_schema.TABLES where table_schema=database() and table_type='SEQUENCE'" : super.getQuerySequencesString();
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getSequenceSupport().supportsSequences() ? SequenceInformationExtractorMariaDBDatabaseImpl.INSTANCE : super.getSequenceInformationExtractor();
    }

    @Override
    public LockingSupport getLockingSupport() {
        return this.lockingSupport;
    }

    @Override
    protected boolean supportsAliasLocks() {
        return false;
    }

    @Override
    protected boolean supportsForShare() {
        return false;
    }

    @Override
    public boolean supportsInsertReturning() {
        return true;
    }

    @Override
    public boolean supportsUpdateReturning() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return MariaDBIdentityColumnSupport.INSTANCE;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_GROUP_AND_CONSTANTS;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData metadata) throws SQLException {
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        return super.buildIdentifierHelper(builder, metadata);
    }

    @Override
    public String getDual() {
        return "dual";
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (sqlException.getErrorCode()) {
                case 1205: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case 1020: {
                    return new SnapshotIsolationException(message, sqlException, sql);
                }
                case 1206: 
                case 1207: 
                case 3572: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 3024: {
                    return new QueryTimeoutException(message, sqlException, sql);
                }
                case 1062: {
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
                case 1048: 
                case 1364: {
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.NOT_NULL, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
                case 1451: 
                case 1452: {
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.FOREIGN_KEY, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
                case 3819: 
                case 4025: {
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.CHECK, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
            }
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "41000": {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    case "40001": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    @Override
    public boolean equivalentTypes(int typeCode1, int typeCode2) {
        return typeCode1 == -1 && typeCode2 == 3001 || typeCode1 == 3001 && typeCode2 == -1 || super.equivalentTypes(typeCode1, typeCode2);
    }

    @Override
    public boolean supportsIntersect() {
        return true;
    }

    @Override
    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        if (optionalTableUpdate.getNumberOfOptimisticLockBindings() == 0) {
            MariaDBSqlAstTranslator translator = new MariaDBSqlAstTranslator(factory, optionalTableUpdate, this);
            return translator.createMergeOperation(optionalTableUpdate);
        }
        return super.createOptionalTableUpdateOperation(mutationTarget, optionalTableUpdate, factory);
    }
}

