/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayTrimFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;

public class PostgreSQLArrayTrimEmulation
extends AbstractArrayTrimFunction {
    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        BasicPluralType pluralType;
        SqlAstNode arrayExpression = sqlAstArguments.get(0);
        SqlAstNode elementCountExpression = sqlAstArguments.get(1);
        sqlAppender.append("coalesce((select array_agg(t.val order by t.idx) from unnest(");
        arrayExpression.accept(walker);
        sqlAppender.append(") with ordinality t(val,idx) where t.idx<=cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append(")-");
        elementCountExpression.accept(walker);
        String arrayTypeName = null;
        if (returnType instanceof BasicPluralType && PostgreSQLArrayTrimEmulation.needsArrayCasting((pluralType = (BasicPluralType)returnType).getElementType())) {
            arrayTypeName = DdlTypeHelper.getCastTypeName(returnType, walker.getSessionFactory().getTypeConfiguration());
        }
        if (arrayTypeName != null) {
            sqlAppender.append("),cast(array[] as ");
            sqlAppender.appendSql(arrayTypeName);
            sqlAppender.appendSql("))");
        } else {
            sqlAppender.append("),array[])");
        }
    }

    private static boolean needsArrayCasting(BasicType<?> elementType) {
        return elementType.getJdbcType().isString();
    }
}

