/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonQueryFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonQueryFunction
extends JsonQueryFunction {
    public SQLServerJsonQueryFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonQueryFunction.JsonQueryArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonQueryErrorBehavior.ERROR) {
            throw new QueryException("Can't emulate on error clause on SQL server");
        }
        List<JsonPathHelper.JsonPathElement> jsonPathElements = JsonPathHelper.parseJsonPathElements((String)walker.getLiteralValue(arguments.jsonPath()));
        if (arguments.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_ARRAY || arguments.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_OBJECT) {
            sqlAppender.appendSql("coalesce(");
        }
        this.render(sqlAppender, arguments, jsonPathElements, jsonPathElements.size() - 1, walker);
        if (arguments.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_ARRAY) {
            sqlAppender.appendSql(",'[]')");
        } else if (arguments.emptyBehavior() == JsonQueryEmptyBehavior.EMPTY_OBJECT) {
            sqlAppender.appendSql(",'{}')");
        }
    }

    private void render(SqlAppender sqlAppender, JsonQueryFunction.JsonQueryArguments arguments, List<JsonPathHelper.JsonPathElement> jsonPathElements, int index, SqlAstTranslator<?> walker) {
        boolean aggregate;
        sqlAppender.appendSql("(select ");
        boolean bl = aggregate = index == jsonPathElements.size() - 1 && (arguments.wrapMode() == JsonQueryWrapMode.WITH_WRAPPER || arguments.wrapMode() == JsonQueryWrapMode.WITH_CONDITIONAL_WRAPPER);
        if (aggregate) {
            if (arguments.wrapMode() == JsonQueryWrapMode.WITH_WRAPPER) {
                sqlAppender.appendSql("'['+");
            } else {
                sqlAppender.appendSql("case when count(*)>1 then '[' else '' end+");
            }
            sqlAppender.appendSql("string_agg(t.v,',')");
            if (arguments.wrapMode() == JsonQueryWrapMode.WITH_WRAPPER) {
                sqlAppender.appendSql("+']'");
            } else {
                sqlAppender.appendSql("+case when count(*)>1 then ']' else '' end");
            }
            sqlAppender.appendSql(" from (select ");
            sqlAppender.appendSql("case t.type when 0 then 'null' when 1 then ");
            sqlAppender.appendSql("(select substring(a.v,6,len(a.v)-6) from (select t.value a for json path,without_array_wrapper) a(v))");
            sqlAppender.appendSql(" else t.value end v");
        } else {
            sqlAppender.appendSql("t.value");
        }
        sqlAppender.appendSql(" from openjson(");
        if (index == 0) {
            arguments.jsonDocument().accept(walker);
        } else {
            this.render(sqlAppender, arguments, jsonPathElements, index - 1, walker);
        }
        sqlAppender.appendSql(')');
        if (arguments.emptyBehavior() == JsonQueryEmptyBehavior.ERROR) {
            sqlAppender.appendSql(" with (value nvarchar(max) ");
            JsonPathHelper.JsonPathElement jsonPathElement = jsonPathElements.get(index);
            if (jsonPathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)jsonPathElement;
                sqlAppender.appendSql("'strict $.");
                for (int i = 0; i < attribute.attribute().length(); ++i) {
                    char c = attribute.attribute().charAt(i);
                    if (c == '\'') {
                        sqlAppender.append('\'');
                    }
                    sqlAppender.append(c);
                }
                sqlAppender.append('\'');
            } else if (jsonPathElement instanceof JsonPathHelper.JsonIndexAccess) {
                JsonPathHelper.JsonIndexAccess indexAccess = (JsonPathHelper.JsonIndexAccess)jsonPathElement;
                sqlAppender.appendSql("'strict $[");
                sqlAppender.appendSql(indexAccess.index());
                sqlAppender.appendSql("]'");
            } else if (jsonPathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                JsonPathHelper.JsonParameterIndexAccess indexAccess = (JsonPathHelper.JsonParameterIndexAccess)jsonPathElement;
                JsonPathPassingClause passingClause = arguments.passingClause();
                assert (passingClause != null);
                Object literalValue = walker.getLiteralValue(passingClause.getPassingExpressions().get(indexAccess.parameterName()));
                sqlAppender.appendSql("'strict $[");
                sqlAppender.appendSql(literalValue.toString());
                sqlAppender.appendSql("]'");
            } else {
                throw new UnsupportedOperationException("Unsupported JSON path expression: " + String.valueOf(jsonPathElement));
            }
            sqlAppender.appendSql(" as json) t");
        } else {
            sqlAppender.appendSql(" t where ");
            JsonPathHelper.JsonPathElement jsonPathElement = jsonPathElements.get(index);
            if (jsonPathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)jsonPathElement;
                sqlAppender.appendSql("t.[key]=");
                sqlAppender.appendSingleQuoteEscapedString(attribute.attribute());
            } else if (jsonPathElement instanceof JsonPathHelper.JsonIndexAccess) {
                JsonPathHelper.JsonIndexAccess indexAccess = (JsonPathHelper.JsonIndexAccess)jsonPathElement;
                sqlAppender.appendSql("t.[key]=");
                sqlAppender.appendSql(indexAccess.index());
            } else if (jsonPathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                JsonPathHelper.JsonParameterIndexAccess indexAccess = (JsonPathHelper.JsonParameterIndexAccess)jsonPathElement;
                JsonPathPassingClause passingClause = arguments.passingClause();
                assert (passingClause != null);
                sqlAppender.appendSql("t.[key]=");
                passingClause.getPassingExpressions().get(indexAccess.parameterName()).accept(walker);
            } else {
                throw new UnsupportedOperationException("Unsupported JSON path expression: " + String.valueOf(jsonPathElement));
            }
        }
        if (aggregate) {
            sqlAppender.appendSql(") t");
        }
        sqlAppender.appendSql(")");
    }
}

