/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.lang.invoke.MethodHandles;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.OnLockVisitor;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class DefaultLockEventListener
implements LockEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)DefaultLockEventListener.class.getName());

    @Override
    public void onLock(LockEvent event) throws HibernateException {
        Object entity;
        EventSource source;
        PersistenceContext persistenceContext;
        EntityEntry entry;
        if (event.getObject() == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (event.getLockMode() == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for lock()");
        }
        if (event.getLockMode() == LockMode.UPGRADE_SKIPLOCKED) {
            LOG.explicitSkipLockedLockCombo();
        }
        if ((entry = (persistenceContext = (source = event.getSession()).getPersistenceContextInternal()).getEntry(entity = persistenceContext.unproxyAndReassociate(event.getObject()))) == null) {
            EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
            Object id = persister.getIdentifier(entity, source);
            if (!ForeignKeys.isNotTransient(event.getEntityName(), entity, Boolean.FALSE, source)) {
                throw new TransientObjectException("Cannot lock unsaved transient instance of entity '" + persister.getEntityName() + "'");
            }
            entry = this.reassociate(event, entity, id, persister);
            this.cascadeOnLock(event, persister, entity);
        }
        LoaderHelper.upgradeLock(entity, entry, event.getLockOptions(), event.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnLock(LockEvent event, EntityPersister persister, Object entity) {
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(CascadingActions.LOCK, CascadePoint.AFTER_LOCK, source, persister, entity, event.getLockOptions());
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    protected final EntityEntry reassociate(AbstractEvent event, Object object, Object id, EntityPersister persister) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reassociating transient instance: " + MessageHelper.infoString(persister, id, event.getFactory()));
        }
        EventSource source = event.getSession();
        EntityKey key = source.generateEntityKey(id, persister);
        PersistenceContext persistenceContext = source.getPersistenceContext();
        persistenceContext.checkUniqueness(key, object);
        Object[] values = persister.getValues(object);
        TypeHelper.deepCopy(values, persister.getPropertyTypes(), persister.getPropertyUpdateability(), values, source);
        EntityEntry newEntry = persistenceContext.addEntity(object, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, values, key, Versioning.getVersion(values, persister), LockMode.NONE, true, persister, false);
        new OnLockVisitor(source, id, object).process(object, persister);
        persister.afterReassociate(object, source);
        return newEntry;
    }
}

