/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import java.util.EnumSet;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Generated;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;

public class GeneratedGeneration
implements OnExecutionGenerator {
    private final EnumSet<EventType> eventTypes;
    private final boolean writable;
    private final String[] sql;

    public GeneratedGeneration(EnumSet<EventType> eventTypes) {
        this.eventTypes = eventTypes;
        this.writable = false;
        this.sql = null;
    }

    public GeneratedGeneration(Generated annotation) {
        String[] stringArray;
        this.eventTypes = EventTypeSets.fromArray(annotation.event());
        if (StringHelper.isEmpty(annotation.sql())) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = annotation.sql();
        }
        this.sql = stringArray;
        this.writable = annotation.writable();
        if (this.sql != null && this.writable) {
            throw new AnnotationException("A field marked '@Generated(writable=true)' may not specify explicit 'sql'");
        }
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return this.writable || this.sql != null;
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return this.sql;
    }

    @Override
    public boolean writePropertyValue() {
        return this.writable;
    }

    @Override
    public boolean generatedOnExecution(Object entity, SharedSessionContractImplementor session) {
        if (this.writable) {
            EntityPersister entityPersister = session.getEntityPersister(null, entity);
            return entityPersister.getGenerator() != this || entityPersister.getIdentifier(entity, session) == null;
        }
        return true;
    }

    @Override
    public boolean allowAssignedIdentifiers() {
        return this.writable;
    }

    @Override
    public boolean allowMutation() {
        return true;
    }
}

