/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;

public final class IdentityMap<K, V>
implements Map<K, V> {
    private final LinkedHashMap<IdentityKey<K>, V> map;
    private transient Map.Entry<K, V>[] entryArray = null;

    public static <K, V> IdentityMap<K, V> instantiateSequenced(int size) {
        return new IdentityMap(new LinkedHashMap(size << 1, 0.6f));
    }

    private IdentityMap(LinkedHashMap<IdentityKey<K>, V> underlyingMap) {
        this.map = underlyingMap;
    }

    public static <K, V> Map.Entry<K, V>[] concurrentEntries(Map<K, V> map) {
        return ((IdentityMap)map).entryArray();
    }

    public static <K, V> void onEachKey(Map<K, V> map, Consumer<K> consumer) {
        IdentityMap identityMap = (IdentityMap)map;
        identityMap.map.forEach((kIdentityKey, v) -> consumer.accept(kIdentityKey.key));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach((k, v) -> action.accept((Object)k.key, (Object)v));
    }

    public Iterator<K> keyIterator() {
        return new KeyIterator<K>(this.map.keySet().iterator());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(new IdentityKey<Object>(key));
    }

    @Override
    public boolean containsValue(Object val) {
        throw new UnsupportedOperationException("Avoid this operation: does not perform well");
    }

    @Override
    public V get(Object key) {
        return this.map.get(new IdentityKey<Object>(key));
    }

    @Override
    public V put(K key, V value) {
        this.entryArray = null;
        return this.map.put(new IdentityKey<K>(key), value);
    }

    @Override
    public V remove(Object key) {
        this.entryArray = null;
        return this.map.remove(new IdentityKey<Object>(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> otherMap) {
        for (Map.Entry<K, V> entry : otherMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.entryArray = null;
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = CollectionHelper.setOfSize(this.map.size());
        for (Map.Entry<IdentityKey<K>, V> entry : this.map.entrySet()) {
            set.add(new IdentityMapEntry(entry.getKey().key, entry.getValue()));
        }
        return set;
    }

    public Map.Entry<K, V>[] entryArray() {
        if (this.entryArray == null) {
            this.entryArray = new Map.Entry[this.map.size()];
            Iterator<Map.Entry<IdentityKey<K>, V>> iterator = this.map.entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Map.Entry<IdentityKey<K>, V> entry = iterator.next();
                this.entryArray[i++] = new IdentityMapEntry(entry.getKey().key, entry.getValue());
            }
        }
        return this.entryArray;
    }

    public String toString() {
        return this.map.toString();
    }

    private record KeyIterator<K>(Iterator<IdentityKey<K>> identityKeyIterator) implements Iterator<K>
    {
        @Override
        public boolean hasNext() {
            return this.identityKeyIterator.hasNext();
        }

        @Override
        public K next() {
            return this.identityKeyIterator.next().key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private record IdentityKey<K>(K key) implements Serializable
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (!(other instanceof IdentityKey)) return false;
            IdentityKey that = (IdentityKey)other;
            if (this.key != that.key) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key);
        }

        @Override
        public String toString() {
            return this.key.toString();
        }
    }

    private record IdentityMapEntry<K, V>(K key, V value) implements Map.Entry<K, V>
    {
        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

