/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class MultiNaturalIdLoadingBatcher {
    private final EntityMappingType entityDescriptor;
    private final SelectStatement sqlSelect;
    private final JdbcParametersList jdbcParameters;
    private final KeyValueResolver keyValueResolver;
    private final JdbcOperationQuerySelect jdbcSelect;
    private final LockOptions lockOptions;

    public MultiNaturalIdLoadingBatcher(EntityMappingType entityDescriptor, ModelPart restrictedPart, int batchSize, KeyValueResolver keyValueResolver, LoadQueryInfluencers loadQueryInfluencers, final LockOptions lockOptions, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        this.sqlSelect = LoaderSelectBuilder.createSelect((Loadable)entityDescriptor, null, restrictedPart, null, batchSize, loadQueryInfluencers, lockOptions, jdbcParametersBuilder::add, sessionFactory);
        this.jdbcParameters = jdbcParametersBuilder.build();
        this.keyValueResolver = keyValueResolver;
        SqlAstTranslatorFactory sqlAstTranslatorFactory = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        this.jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.sqlSelect).translate(null, new QueryOptionsAdapter(){

            @Override
            public LockOptions getLockOptions() {
                return lockOptions;
            }
        });
        this.lockOptions = lockOptions;
    }

    public <E> List<E> multiLoad(Object[] naturalIdValues, SharedSessionContractImplementor session) {
        ArrayList multiLoadResults = CollectionHelper.arrayList(naturalIdValues.length);
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = 0;
        int size = 0;
        for (Object naturalIdValue : naturalIdValues) {
            Object bindValue = this.keyValueResolver.resolveKeyToLoad(naturalIdValue, session);
            if (bindValue != null) {
                offset += jdbcParamBindings.registerParametersForEachJdbcValue(bindValue, offset, this.entityDescriptor.getNaturalIdMapping(), this.jdbcParameters, session);
                ++size;
            }
            if (offset != this.jdbcParameters.size()) continue;
            List<E> batchResults = this.performLoad(jdbcParamBindings, session, size);
            multiLoadResults.addAll(batchResults);
            jdbcParamBindings.clear();
            offset = 0;
            size = 0;
        }
        if (offset != 0) {
            while (offset != this.jdbcParameters.size()) {
                offset += jdbcParamBindings.registerParametersForEachJdbcValue(null, offset, this.entityDescriptor.getNaturalIdMapping(), this.jdbcParameters, session);
                ++size;
            }
            List<E> batchResults = this.performLoad(jdbcParamBindings, session, size);
            multiLoadResults.addAll(batchResults);
        }
        return multiLoadResults;
    }

    private <E> List<E> performLoad(JdbcParameterBindings jdbcParamBindings, SharedSessionContractImplementor session, int size) {
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = session.getLoadQueryInfluencers().hasSubselectLoadableCollections(this.entityDescriptor.getEntityPersister()) ? SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), this.sqlSelect, this.jdbcParameters, jdbcParamBindings) : null;
        return session.getJdbcServices().getJdbcSelectExecutor().list(this.jdbcSelect, jdbcParamBindings, new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler, false, this.lockOptions), RowTransformerStandardImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, size);
    }

    @FunctionalInterface
    static interface KeyValueResolver {
        public Object resolveKeyToLoad(Object var1, SharedSessionContractImplementor var2);
    }
}

