/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import java.util.Set;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.hibernate.AssertionFailure;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmTreeCreationHelper {
    private static final Set<String> RESERVED_WORDS = Set.of("abs", "all", "and", "any", "as", "asc", "avg", "between", "bit_length", "both", "by", "case", "ceiling", "char_length", "character_length", "class", "coalesce", "concat", "count", "current_date", "current_time", "current_timestamp", "delete", "desc", "distinct", "else", "empty", "end", "entry", "escape", "exists", "exp", "extract", "false", "fetch", "first", "floor", "from", "function", "group", "having", "in", "index", "inner", "is", "join", "key", "leading", "last", "left", "length", "like", "local", "ln", "locate", "lower", "max", "member", "min", "mod", "new", "not", "null", "nulls", "nullif", "object", "of", "on", "or", "order", "outer", "position", "power", "replace", "right", "round", "select", "set", "sign", "size", "some", "sqrt", "substring", "sum", "then", "trailing", "treat", "trim", "true", "type", "unknown", "update", "upper", "value", "when", "where");

    public static <E> void handleRootAsCrossJoin(HqlParser.EntityWithJoinsContext entityWithJoinsContext, SqmRoot<E> sqmPrimaryRoot, SemanticQueryBuilder<?> sqmBuilder) {
        HqlParser.RootEntityContext fromRootContext = (HqlParser.RootEntityContext)entityWithJoinsContext.fromRoot();
        SqmRoot sqmRoot = (SqmRoot)fromRootContext.accept(sqmBuilder);
        SqmEntityJoin pseudoCrossJoin = new SqmEntityJoin(sqmRoot.getManagedType(), SqmTreeCreationHelper.extractAlias(fromRootContext.variable(), sqmBuilder), SqmJoinType.CROSS, sqmPrimaryRoot);
        sqmPrimaryRoot.addSqmJoin(pseudoCrossJoin);
        sqmBuilder.getProcessingStateStack().getCurrent().getPathRegistry().replace(pseudoCrossJoin, sqmRoot);
        int size = entityWithJoinsContext.getChildCount();
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = entityWithJoinsContext.getChild(i);
            if (parseTree instanceof HqlParser.CrossJoinContext) {
                HqlParser.CrossJoinContext crossJoinContext = (HqlParser.CrossJoinContext)parseTree;
                sqmBuilder.consumeCrossJoin(crossJoinContext, sqmPrimaryRoot);
                continue;
            }
            if (parseTree instanceof HqlParser.JoinContext) {
                HqlParser.JoinContext joinContext = (HqlParser.JoinContext)parseTree;
                sqmBuilder.consumeJoin(joinContext, sqmPrimaryRoot);
                continue;
            }
            if (!(parseTree instanceof HqlParser.JpaCollectionJoinContext)) continue;
            HqlParser.JpaCollectionJoinContext collectionJoinContext = (HqlParser.JpaCollectionJoinContext)parseTree;
            sqmBuilder.consumeJpaCollectionJoin(collectionJoinContext, sqmPrimaryRoot);
        }
    }

    public static String extractAlias(HqlParser.VariableContext ctx, SemanticQueryBuilder<?> sqmBuilder) {
        return SqmTreeCreationHelper.extractVariable(ctx, sqmBuilder);
    }

    public static String extractJpaCompliantAlias(HqlParser.VariableContext ctx, SemanticQueryBuilder<?> sqmBuilder) {
        return SqmTreeCreationHelper.applyJpaCompliance(SqmTreeCreationHelper.extractVariable(ctx, sqmBuilder), sqmBuilder);
    }

    public static String extractVariable(HqlParser.VariableContext ctx, SemanticQueryBuilder<?> sqmBuilder) {
        if (ctx == null) {
            return null;
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 1);
        if (lastChild instanceof HqlParser.IdentifierContext) {
            HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)lastChild;
            SqmTreeCreationHelper.checkJpaCompliance(sqmBuilder, identifierContext.getStart());
            return sqmBuilder.visitIdentifier(identifierContext);
        }
        if (lastChild instanceof HqlParser.NakedIdentifierContext) {
            HqlParser.NakedIdentifierContext identifierContext = (HqlParser.NakedIdentifierContext)lastChild;
            SqmTreeCreationHelper.checkJpaCompliance(sqmBuilder, identifierContext.getStart());
            return sqmBuilder.visitNakedIdentifier(identifierContext);
        }
        throw new AssertionFailure("Unexpected type parse of tree");
    }

    private static void checkJpaCompliance(SemanticQueryBuilder<?> sqmBuilder, Token identificationVariable) {
        if (sqmBuilder.getCreationOptions().useStrictJpaCompliance() && RESERVED_WORDS.contains(identificationVariable.getText().toLowerCase(Locale.ENGLISH))) {
            throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariable.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
        }
    }

    public static String applyJpaCompliance(String text, SemanticQueryBuilder<?> sqmBuilder) {
        return text != null && sqmBuilder.getCreationOptions().useStrictJpaCompliance() ? text.toLowerCase(Locale.getDefault()) : text;
    }
}

