/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.hibernate.Filter;
import org.hibernate.Incubating;
import org.hibernate.QueryParameterException;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryParameterBindingImpl;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.type.BindableType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypedExpressible;
import org.hibernate.type.spi.TypeConfiguration;

@Incubating
public class QueryParameterBindingsImpl
implements QueryParameterBindings {
    public static final QueryParameterBindings EMPTY = QueryParameterBindingsImpl.from(ParameterMetadataImpl.EMPTY, null);
    private final ParameterMetadataImplementor parameterMetadata;
    private final LinkedHashMap<QueryParameter<?>, QueryParameterBinding<?>> parameterBindingMap;
    private final HashMap<Object, QueryParameterBinding<?>> parameterBindingMapByNameOrPosition;

    public static QueryParameterBindingsImpl from(ParameterMetadataImplementor parameterMetadata, SessionFactoryImplementor sessionFactory) {
        if (parameterMetadata == null) {
            throw new QueryParameterException("Query parameter metadata cannot be null");
        }
        return new QueryParameterBindingsImpl(sessionFactory, parameterMetadata);
    }

    private QueryParameterBindingsImpl(SessionFactoryImplementor sessionFactory, ParameterMetadataImplementor parameterMetadata) {
        this.parameterMetadata = parameterMetadata;
        Set<QueryParameter<?>> queryParameters = parameterMetadata.getRegistrations();
        this.parameterBindingMap = CollectionHelper.linkedMapOfSize(queryParameters.size());
        this.parameterBindingMapByNameOrPosition = CollectionHelper.mapOfSize(queryParameters.size());
        for (QueryParameter<?> queryParameter : queryParameters) {
            this.parameterBindingMap.put(queryParameter, QueryParameterBindingsImpl.createBinding(sessionFactory, parameterMetadata, queryParameter));
        }
        for (Map.Entry entry : this.parameterBindingMap.entrySet()) {
            QueryParameter queryParameter = (QueryParameter)entry.getKey();
            if (queryParameter.isNamed()) {
                this.parameterBindingMapByNameOrPosition.put(queryParameter.getName(), (QueryParameterBinding)entry.getValue());
                continue;
            }
            if (queryParameter.getPosition() == null) continue;
            this.parameterBindingMapByNameOrPosition.put(queryParameter.getPosition(), (QueryParameterBinding)entry.getValue());
        }
    }

    private static <T> QueryParameterBindingImpl<T> createBinding(SessionFactoryImplementor factory, ParameterMetadataImplementor parameterMetadata, QueryParameter<T> parameter) {
        return new QueryParameterBindingImpl<T>(parameter, factory, parameterMetadata.getInferredParameterType(parameter));
    }

    private QueryParameterBindingsImpl(QueryParameterBindingsImpl original, SessionFactoryImplementor sessionFactory) {
        this.parameterMetadata = original.parameterMetadata;
        this.parameterBindingMap = CollectionHelper.linkedMapOfSize(original.parameterBindingMap.size());
        this.parameterBindingMapByNameOrPosition = CollectionHelper.mapOfSize(original.parameterBindingMapByNameOrPosition.size());
        for (Map.Entry<QueryParameter<?>, QueryParameterBinding<?>> entry : original.parameterBindingMap.entrySet()) {
            this.parameterBindingMap.put(entry.getKey(), QueryParameterBindingsImpl.createBinding(sessionFactory, entry.getValue()));
        }
        for (Map.Entry<QueryParameter<?>, QueryParameterBinding<?>> entry : this.parameterBindingMap.entrySet()) {
            QueryParameter<?> queryParameter = entry.getKey();
            if (queryParameter.isNamed()) {
                this.parameterBindingMapByNameOrPosition.put(queryParameter.getName(), entry.getValue());
                continue;
            }
            if (queryParameter.getPosition() == null) continue;
            this.parameterBindingMapByNameOrPosition.put(queryParameter.getPosition(), entry.getValue());
        }
    }

    private static <T> QueryParameterBindingImpl<T> createBinding(SessionFactoryImplementor factory, QueryParameterBinding<T> binding) {
        return new QueryParameterBindingImpl<T>(binding.getQueryParameter(), factory, binding.getBindType());
    }

    public QueryParameterBindingsImpl copyWithoutValues(SessionFactoryImplementor sessionFactory) {
        return new QueryParameterBindingsImpl(this, sessionFactory);
    }

    @Override
    public boolean isBound(QueryParameterImplementor<?> parameter) {
        return this.getBinding(parameter).isBound();
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(QueryParameterImplementor<P> parameter) {
        QueryParameterBinding<?> binding = this.parameterBindingMap.get(parameter);
        if (binding == null) {
            throw new IllegalArgumentException("Cannot create binding for parameter reference [" + String.valueOf(parameter) + "] - reference is not a parameter of this query");
        }
        return binding;
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(int position) {
        QueryParameterBinding<?> binding = this.parameterBindingMapByNameOrPosition.get(position);
        if (binding == null) {
            this.parameterMetadata.getQueryParameter(position);
        }
        return binding;
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(String name) {
        QueryParameterBinding<?> binding = this.parameterBindingMapByNameOrPosition.get(name);
        if (binding == null) {
            this.parameterMetadata.getQueryParameter(name);
        }
        return binding;
    }

    @Override
    public void validate() {
        for (Map.Entry<QueryParameter<?>, QueryParameterBinding<?>> entry : this.parameterBindingMap.entrySet()) {
            if (entry.getValue().isBound()) continue;
            QueryParameter<?> queryParameter = entry.getKey();
            if (queryParameter.isNamed()) {
                throw new QueryParameterException("No argument for named parameter ':" + queryParameter.getName() + "'");
            }
            throw new QueryParameterException("No argument for ordinal parameter '?" + queryParameter.getPosition() + "'");
        }
    }

    @Override
    public boolean hasAnyMultiValuedBindings() {
        for (QueryParameterBinding<?> binding : this.parameterBindingMap.values()) {
            if (!binding.isMultiValued()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitBindings(BiConsumer<? super QueryParameter<?>, ? super QueryParameterBinding<?>> action) {
        this.parameterBindingMap.forEach(action);
    }

    @Override
    public QueryKey.ParameterBindingsMemento generateQueryKeyMemento(SharedSessionContractImplementor session) {
        MutableCacheKeyImpl mutableCacheKey = new MutableCacheKeyImpl(this.parameterBindingMap.size());
        JavaType<Object> tenantIdentifierJavaType = session.getFactory().getTenantIdentifierJavaType();
        Object tenantId = session.getTenantIdentifierValue();
        mutableCacheKey.addValue(tenantIdentifierJavaType.getMutabilityPlan().disassemble(tenantId, session));
        mutableCacheKey.addHashCode(tenantId == null ? 0 : tenantIdentifierJavaType.extractHashCode(tenantId));
        this.handleQueryParameters(session, mutableCacheKey);
        QueryParameterBindingsImpl.handleFilterParameters(session, mutableCacheKey);
        return mutableCacheKey.build();
    }

    private void handleQueryParameters(SharedSessionContractImplementor session, MutableCacheKeyImpl mutableCacheKey) {
        TypeConfiguration typeConfiguration = session.getFactory().getTypeConfiguration();
        for (Map.Entry<QueryParameter<?>, QueryParameterBinding<?>> entry : this.parameterBindingMap.entrySet()) {
            QueryParameter<?> queryParameter = entry.getKey();
            QueryParameterBinding<?> binding = entry.getValue();
            assert (binding.isBound()) : "Found unbound query parameter while generating cache key";
            MappingModelExpressible<?> mappingType = QueryParameterBindingsImpl.determineMappingType(binding, queryParameter, typeConfiguration);
            if (binding.isMultiValued()) {
                for (Object bindValue : binding.getBindValues()) {
                    assert (bindValue != null);
                    mappingType.addToCacheKey(mutableCacheKey, bindValue, session);
                }
                continue;
            }
            Object bindValue = binding.getBindValue();
            mappingType.addToCacheKey(mutableCacheKey, bindValue, session);
        }
    }

    private static void handleFilterParameters(SharedSessionContractImplementor session, MutableCacheKeyImpl mutableCacheKey) {
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        for (Map.Entry<String, Filter> entry : loadQueryInfluencers.getEnabledFilters().entrySet()) {
            FilterImpl filter = (FilterImpl)entry.getValue();
            FilterDefinition filterDefinition = filter.getFilterDefinition();
            for (Map.Entry<String, ?> paramEntry : filter.getParameters().entrySet()) {
                String parameterName = paramEntry.getKey();
                Object paramValue = paramEntry.getValue();
                JdbcMapping jdbcMapping = filterDefinition.getParameterJdbcMapping(parameterName);
                assert (jdbcMapping != null) : "Undefined filter parameter '" + parameterName + "'";
                CacheHelper.addBasicValueToCacheKey(mutableCacheKey, paramValue, jdbcMapping, session);
            }
        }
    }

    private static MappingModelExpressible<?> determineMappingType(QueryParameterBinding<?> binding, QueryParameter<?> queryParameter, TypeConfiguration typeConfiguration) {
        JavaTypedExpressible javaTypedExpressible;
        JavaType jtd;
        BindableType<?> bindType = binding.getBindType();
        if (bindType instanceof MappingModelExpressible) {
            MappingModelExpressible mappingModelExpressible = (MappingModelExpressible)((Object)bindType);
            return mappingModelExpressible;
        }
        MappingModelExpressible<?> type = binding.getType();
        if (type != null) {
            return type;
        }
        if (bindType instanceof JavaTypedExpressible && (jtd = (javaTypedExpressible = (JavaTypedExpressible)((Object)bindType)).getExpressibleJavaType()).getJavaTypeClass() != null) {
            return typeConfiguration.getBasicTypeForJavaType(jtd.getJavaTypeClass());
        }
        if (binding.isMultiValued()) {
            Object firstNonNullBindValue;
            Iterator<?> iterator = binding.getBindValues().iterator();
            Object object = firstNonNullBindValue = iterator.hasNext() ? (Object)iterator.next() : null;
            if (firstNonNullBindValue != null) {
                return typeConfiguration.getBasicTypeForJavaType(firstNonNullBindValue.getClass());
            }
        } else if (binding.getBindValue() != null) {
            return typeConfiguration.getBasicTypeForJavaType(binding.getBindValue().getClass());
        }
        if (bindType == null) {
            if (queryParameter.isNamed()) {
                throw new QueryParameterException("Could not determine mapping type for named parameter ':" + queryParameter.getName() + "'");
            }
            throw new QueryParameterException("Could not determine mapping type for ordinal parameter '?" + queryParameter.getPosition() + "'");
        }
        return typeConfiguration.getBasicTypeForJavaType(bindType.getJavaType());
    }

    private static class MutableCacheKeyImpl
    implements MutableCacheKeyBuilder {
        final List<Object> values;
        int hashCode;

        public MutableCacheKeyImpl(int parameterBindingMapSize) {
            this.values = new ArrayList<Object>(parameterBindingMapSize);
        }

        @Override
        public void addValue(Object value) {
            this.values.add(value);
        }

        @Override
        public void addHashCode(int hashCode) {
            this.hashCode = 37 * this.hashCode + hashCode;
        }

        @Override
        public QueryKey.ParameterBindingsMemento build() {
            return new ParameterBindingsMementoImpl(this.values.toArray(new Object[0]), this.hashCode);
        }
    }

    private static class ParameterBindingsMementoImpl
    implements QueryKey.ParameterBindingsMemento {
        final Object[] values;
        final int hashCode;

        private ParameterBindingsMementoImpl(Object[] values, int hashCode) {
            this.values = values;
            this.hashCode = hashCode;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (!(that instanceof ParameterBindingsMementoImpl)) {
                return false;
            }
            ParameterBindingsMementoImpl queryKey = (ParameterBindingsMementoImpl)that;
            if (this.hashCode != queryKey.hashCode) {
                return false;
            }
            return Arrays.deepEquals(this.values, queryKey.values);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

